/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.concurrent;

import io.nadron.app.GameRoom;
import io.nadron.concurrent.Lane;
import io.nadron.concurrent.Lanes;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public interface LaneStrategy<LANE_ID_TYPE, UNDERLYING_LANE, GROUP> {
    public Lane<LANE_ID_TYPE, UNDERLYING_LANE> chooseLane(GROUP var1);

    public static enum LaneStrategies implements LaneStrategy<String, ExecutorService, GameRoom>
    {
        ROUND_ROBIN{
            final AtomicInteger currentLane = new AtomicInteger(0);
            final int laneSize = this.lanes.length;

            @Override
            public Lane<String, ExecutorService> chooseLane(GameRoom group) {
                this.currentLane.compareAndSet(this.laneSize, 0);
                return this.lanes[this.currentLane.getAndIncrement()];
            }
        }
        ,
        GROUP_BY_ROOM{
            private final ConcurrentMap<GameRoom, Lane<String, ExecutorService>> roomLaneMap = new ConcurrentHashMap<GameRoom, Lane<String, ExecutorService>>();
            private final ConcurrentMap<Lane<String, ExecutorService>, AtomicInteger> laneSessionCounter = new ConcurrentHashMap<Lane<String, ExecutorService>, AtomicInteger>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Lane<String, ExecutorService> chooseLane(GameRoom room) {
                Lane lane = (Lane)this.roomLaneMap.get(room);
                if (null == lane) {
                    ConcurrentMap<Lane<String, ExecutorService>, AtomicInteger> concurrentMap = this.laneSessionCounter;
                    synchronized (concurrentMap) {
                        if (this.laneSessionCounter.isEmpty()) {
                            for (Lane theLane : this.lanes) {
                                this.laneSessionCounter.put(theLane, new AtomicInteger(0));
                            }
                        }
                        Set laneSet = this.laneSessionCounter.keySet();
                        int min = 0;
                        for (Lane theLane : laneSet) {
                            AtomicInteger counter = (AtomicInteger)this.laneSessionCounter.get(theLane);
                            int numOfSessions = counter.get();
                            if (numOfSessions == 0) {
                                lane = theLane;
                                break;
                            }
                            if (min == 0) {
                                min = numOfSessions;
                                lane = theLane;
                            }
                            if (numOfSessions >= min) continue;
                            min = numOfSessions;
                            lane = theLane;
                        }
                        this.roomLaneMap.put(room, lane);
                    }
                }
                ((AtomicInteger)this.laneSessionCounter.get(lane)).incrementAndGet();
                return lane;
            }
        };

        final Lane<String, ExecutorService>[] lanes = Lanes.LANES.getJetLanes();
    }
}

