/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.concurrent;

import io.nadron.concurrent.DefaultLane;
import io.nadron.concurrent.Lane;
import io.nadron.concurrent.ManagedExecutor;
import io.nadron.concurrent.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Lanes {
    LANES;

    final String serverCores = System.getProperty("jet.lanes");
    final int numOfCores;
    final Lane<String, ExecutorService>[] jetLanes;

    private Lanes() {
        Logger LOG = LoggerFactory.getLogger(Lanes.class);
        int cores = 1;
        if (null != this.serverCores) {
            try {
                cores = Integer.parseInt(this.serverCores);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid server cores {} passed in, going to ignore", (Object)this.serverCores);
            }
        }
        this.numOfCores = cores;
        this.jetLanes = new Lane[cores];
        NamedThreadFactory threadFactory = new NamedThreadFactory("Lane", true);
        for (int i = 1; i <= cores; ++i) {
            DefaultLane defaultLane;
            this.jetLanes[i - 1] = defaultLane = new DefaultLane("Lane[" + i + "]", ManagedExecutor.newSingleThreadExecutor(threadFactory));
        }
    }

    public Lane<String, ExecutorService>[] getJetLanes() {
        return this.jetLanes;
    }

    public int getNumOfCores() {
        return this.numOfCores;
    }
}

