/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.event;

import io.nadron.app.Session;
import io.nadron.communication.DeliveryGuaranty;
import io.nadron.communication.MessageSender;
import io.nadron.event.Event;
import io.nadron.event.EventContext;
import io.nadron.event.NetworkEvent;
import io.nadron.event.impl.ChangeAttributeEvent;
import io.nadron.event.impl.DefaultConnectEvent;
import io.nadron.event.impl.DefaultEvent;
import io.nadron.event.impl.DefaultEventContext;
import io.nadron.event.impl.DefaultNetworkEvent;

public class Events {
    public static final byte PROTCOL_VERSION = 1;
    public static final byte ANY = 0;
    public static final byte CONNECT = 2;
    public static final byte RECONNECT = 3;
    public static final byte CONNECT_FAILED = 6;
    public static final byte LOG_IN = 8;
    public static final byte LOG_OUT = 10;
    public static final byte LOG_IN_SUCCESS = 11;
    public static final byte LOG_IN_FAILURE = 12;
    public static final byte LOG_OUT_SUCCESS = 14;
    public static final byte LOG_OUT_FAILURE = 15;
    public static final byte GAME_LIST = 16;
    public static final byte ROOM_LIST = 18;
    public static final byte GAME_ROOM_JOIN = 20;
    public static final byte GAME_ROOM_LEAVE = 22;
    public static final byte GAME_ROOM_JOIN_SUCCESS = 24;
    public static final byte GAME_ROOM_JOIN_FAILURE = 25;
    public static final byte START = 26;
    public static final byte STOP = 27;
    public static final byte SESSION_MESSAGE = 28;
    public static final byte NETWORK_MESSAGE = 29;
    public static final byte CHANGE_ATTRIBUTE = 32;
    public static final byte DISCONNECT = 34;
    public static final byte EXCEPTION = 36;

    public static Event event(Object source, int eventType) {
        return Events.event(source, eventType, (Session)null);
    }

    public static Event event(Object source, int eventType, Session session) {
        DefaultEventContext context = null;
        if (null != session) {
            context = new DefaultEventContext();
        }
        return Events.event(source, eventType, context);
    }

    public static Event event(Object source, int eventType, EventContext context) {
        DefaultEvent event = new DefaultEvent();
        event.setSource(source);
        event.setType(eventType);
        event.setEventContext(context);
        event.setTimeStamp(System.currentTimeMillis());
        return event;
    }

    public static NetworkEvent networkEvent(Object source) {
        return Events.networkEvent(source, DeliveryGuaranty.DeliveryGuarantyOptions.RELIABLE);
    }

    public static NetworkEvent networkEvent(Object source, DeliveryGuaranty deliveryGuaranty) {
        Event event = Events.event(source, 29);
        DefaultNetworkEvent networkEvent = new DefaultNetworkEvent(event);
        networkEvent.setDeliveryGuaranty(deliveryGuaranty);
        return networkEvent;
    }

    public static Event connectEvent(MessageSender.Reliable tcpSender) {
        DefaultConnectEvent event = new DefaultConnectEvent(tcpSender);
        event.setTimeStamp(System.currentTimeMillis());
        return event;
    }

    public static Event connectEvent(MessageSender.Fast udpSender) {
        DefaultConnectEvent event = new DefaultConnectEvent(udpSender);
        event.setTimeStamp(System.currentTimeMillis());
        return event;
    }

    public static Event connectEvent(MessageSender.Reliable tcpSender, MessageSender.Fast udpSender) {
        DefaultConnectEvent event = new DefaultConnectEvent(tcpSender, udpSender);
        event.setTimeStamp(System.currentTimeMillis());
        return event;
    }

    public static Event dataInEvent(Object source) {
        return Events.event(source, 28);
    }

    public static Event changeAttributeEvent(String key, Object value) {
        return new ChangeAttributeEvent(key, value);
    }
}

