/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.event.impl;

import io.nadron.app.PlayerSession;
import io.nadron.app.Session;
import io.nadron.communication.DeliveryGuaranty;
import io.nadron.communication.MessageSender;
import io.nadron.event.ConnectEvent;
import io.nadron.event.Event;
import io.nadron.event.NetworkEvent;
import io.nadron.event.SessionEventHandler;
import io.nadron.event.impl.ChangeAttributeEvent;
import io.nadron.event.impl.DefaultNetworkEvent;
import io.nadron.service.SessionRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionEventHandler
implements SessionEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSessionEventHandler.class);
    private final Session session;

    public DefaultSessionEventHandler(Session session) {
        this.session = session;
    }

    @Override
    public int getEventType() {
        return 0;
    }

    @Override
    public void onEvent(Event event) {
        this.doEventHandlerMethodLookup(event);
    }

    protected void doEventHandlerMethodLookup(Event event) {
        switch (event.getType()) {
            case 28: {
                this.onDataIn(event);
                break;
            }
            case 29: {
                this.onNetworkMessage((NetworkEvent)event);
                break;
            }
            case 11: {
                this.onLoginSuccess(event);
                break;
            }
            case 12: {
                this.onLoginFailure(event);
                break;
            }
            case 2: {
                this.onConnect((ConnectEvent)event);
                break;
            }
            case 26: {
                this.onStart(event);
                break;
            }
            case 27: {
                this.onStart(event);
                break;
            }
            case 6: {
                this.onConnectFailed(event);
                break;
            }
            case 34: {
                this.onDisconnect(event);
                break;
            }
            case 32: {
                this.onChangeAttribute((ChangeAttributeEvent)event);
                break;
            }
            case 36: {
                this.onException(event);
                break;
            }
            case 3: {
                this.onReconnect((ConnectEvent)event);
                break;
            }
            case 10: {
                this.onLogout(event);
                break;
            }
            default: {
                this.onCustomEvent(event);
            }
        }
    }

    protected void onDataIn(Event event) {
        if (null != this.getSession()) {
            PlayerSession pSession = (PlayerSession)this.getSession();
            DefaultNetworkEvent networkEvent = new DefaultNetworkEvent(event);
            if (pSession.isUDPEnabled()) {
                networkEvent.setDeliveryGuaranty(DeliveryGuaranty.DeliveryGuarantyOptions.FAST);
            }
            pSession.getGameRoom().sendBroadcast(networkEvent);
        }
    }

    protected void onNetworkMessage(NetworkEvent event) {
        Session session = this.getSession();
        if (!session.isWriteable()) {
            return;
        }
        DeliveryGuaranty guaranty = event.getDeliveryGuaranty();
        if (guaranty.getGuaranty() == DeliveryGuaranty.DeliveryGuarantyOptions.FAST.getGuaranty()) {
            MessageSender.Fast udpSender = session.getUdpSender();
            if (null != udpSender) {
                udpSender.sendMessage(event);
            } else {
                LOG.trace("Going to discard event: {} since udpSender is null in session: {}", (Object)event, (Object)session);
            }
        } else {
            session.getTcpSender().sendMessage(event);
        }
    }

    protected void onLoginSuccess(Event event) {
        this.getSession().getTcpSender().sendMessage(event);
    }

    protected void onLoginFailure(Event event) {
        this.getSession().getTcpSender().sendMessage(event);
    }

    protected void onConnect(ConnectEvent event) {
        Session session = this.getSession();
        if (null != event.getTcpSender()) {
            session.setTcpSender(event.getTcpSender());
        } else if (null == this.getSession().getTcpSender()) {
            this.logNullTcpConnection(event);
        } else {
            session.setUDPEnabled(true);
            session.setUdpSender(event.getUdpSender());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReconnect(ConnectEvent event) {
        Session session;
        Session session2 = session = this.getSession();
        synchronized (session2) {
            SessionRegistryService reconnectRegistry = (SessionRegistryService)session.getAttribute("RECONNECT_REGISTRY");
            if (null != reconnectRegistry && Session.Status.CLOSED != session.getStatus()) {
                reconnectRegistry.removeSession((String)session.getAttribute("RECONNECT_KEY"));
            }
        }
        this.onConnect(event);
    }

    protected void onStart(Event event) {
        this.getSession().getTcpSender().sendMessage(event);
    }

    protected void onStop(Event event) {
        this.getSession().getTcpSender().sendMessage(event);
    }

    protected void onConnectFailed(Event event) {
    }

    protected void onDisconnect(Event event) {
        LOG.debug("Received disconnect event in session. ");
        this.onException(event);
    }

    protected void onChangeAttribute(ChangeAttributeEvent event) {
        this.getSession().setAttribute(event.getKey(), event.getValue());
    }

    protected void onException(Event event) {
        Session session = this.getSession();
        session.setStatus(Session.Status.NOT_CONNECTED);
        session.setWriteable(false);
        session.setUDPEnabled(false);
        String reconnectKey = (String)session.getAttribute("RECONNECT_KEY");
        SessionRegistryService registry = (SessionRegistryService)session.getAttribute("RECONNECT_REGISTRY");
        if (null != reconnectKey && null != registry) {
            if (null == registry.getSession(reconnectKey)) {
                registry.putSession(reconnectKey, this.getSession());
                LOG.debug("Received exception/disconnect event in session. Going to put session in reconnection registry");
            }
        } else {
            LOG.debug("Received exception/disconnect event in session. Going to close session");
            this.onClose(event);
        }
    }

    protected void onLogout(Event event) {
        this.onClose(event);
    }

    protected void onClose(Event event) {
        this.getSession().close();
    }

    protected void onCustomEvent(Event event) {
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        throw new UnsupportedOperationException("Session is a final variable and cannot be reset.");
    }

    private void logNullTcpConnection(Event event) {
        LOG.warn("Discarding {} as TCP connection is not fully established for this {}", (Object)event, (Object)this.getSession());
    }
}

