/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.event.impl;

import io.nadron.app.Session;
import io.nadron.event.Event;
import io.nadron.event.EventDispatcher;
import io.nadron.event.EventHandler;
import io.nadron.event.SessionEventHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorEventDispatcher
implements EventDispatcher {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private Map<Integer, List<EventHandler>> handlersByEventType;
    private List<EventHandler> genericHandlers;
    private boolean isShuttingDown;

    public ExecutorEventDispatcher() {
        this(new HashMap<Integer, List<EventHandler>>(2), new CopyOnWriteArrayList<EventHandler>());
    }

    public ExecutorEventDispatcher(Map<Integer, List<EventHandler>> handlersByEventType, List<EventHandler> genericHandlers) {
        this.handlersByEventType = handlersByEventType;
        this.genericHandlers = genericHandlers;
        this.isShuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(EventHandler eventHandler) {
        int eventType = eventHandler.getEventType();
        ExecutorEventDispatcher executorEventDispatcher = this;
        synchronized (executorEventDispatcher) {
            if (eventType == 0) {
                this.genericHandlers.add(eventHandler);
            } else {
                List<EventHandler> handlers = this.handlersByEventType.get(eventType);
                if (handlers == null) {
                    handlers = new CopyOnWriteArrayList<EventHandler>();
                    this.handlersByEventType.put(eventType, handlers);
                }
                handlers.add(eventHandler);
            }
        }
    }

    @Override
    public List<EventHandler> getHandlers(int eventType) {
        return this.handlersByEventType.get(eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(EventHandler eventHandler) {
        int eventType = eventHandler.getEventType();
        ExecutorEventDispatcher executorEventDispatcher = this;
        synchronized (executorEventDispatcher) {
            if (eventType == 0) {
                this.genericHandlers.remove(eventHandler);
            } else {
                List<EventHandler> handlers = this.handlersByEventType.get(eventType);
                if (null != handlers) {
                    handlers.remove(eventHandler);
                    if (handlers.size() == 0) {
                        this.handlersByEventType.put(eventType, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandlersForEvent(int eventType) {
        ExecutorEventDispatcher executorEventDispatcher = this;
        synchronized (executorEventDispatcher) {
            List<EventHandler> handlers = this.handlersByEventType.get(eventType);
            if (null != handlers) {
                handlers.clear();
            }
        }
    }

    @Override
    public boolean removeHandlersForSession(Session session) {
        ArrayList<EventHandler> removeList = new ArrayList<EventHandler>();
        Collection<List<EventHandler>> eventHandlersList = this.handlersByEventType.values();
        for (List<EventHandler> handlerList : eventHandlersList) {
            if (null == handlerList) continue;
            for (EventHandler handler : handlerList) {
                SessionEventHandler sessionHandler;
                if (!(handler instanceof SessionEventHandler) || !(sessionHandler = (SessionEventHandler)handler).getSession().equals(session)) continue;
                removeList.add(handler);
            }
        }
        for (EventHandler handler : removeList) {
            this.removeHandler(handler);
        }
        return removeList.size() > 0;
    }

    @Override
    public synchronized void clear() {
        if (null != this.handlersByEventType) {
            this.handlersByEventType.clear();
        }
        if (null != this.genericHandlers) {
            this.genericHandlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(final Event event) {
        boolean isShuttingDown = false;
        ExecutorEventDispatcher executorEventDispatcher = this;
        synchronized (executorEventDispatcher) {
            isShuttingDown = this.isShuttingDown;
        }
        if (!isShuttingDown) {
            EXECUTOR.submit(new Runnable(){

                @Override
                public void run() {
                    for (EventHandler handler : ExecutorEventDispatcher.this.genericHandlers) {
                        handler.onEvent(event);
                    }
                    List handlers = (List)ExecutorEventDispatcher.this.handlersByEventType.get(event.getType());
                    if (null != handlers) {
                        for (EventHandler handler : handlers) {
                            handler.onEvent(event);
                        }
                    }
                }
            });
        } else {
            System.err.println("Discarding event: " + event + " as dispatcher is shutting down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ExecutorEventDispatcher executorEventDispatcher = this;
        synchronized (executorEventDispatcher) {
            this.isShuttingDown = true;
            this.genericHandlers.clear();
            this.handlersByEventType.clear();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTOR.shutdown();
            }
        });
    }
}

