/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.event.impl;

import io.nadron.app.Session;
import io.nadron.concurrent.Lane;
import io.nadron.event.Event;
import io.nadron.event.EventDispatcher;
import io.nadron.event.EventHandler;
import io.nadron.event.SessionEventHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetlang.channels.BatchSubscriber;
import org.jetlang.channels.MemoryChannel;
import org.jetlang.channels.Subscribable;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.core.Filter;
import org.jetlang.fibers.Fiber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetlangEventDispatcher
implements EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JetlangEventDispatcher.class);
    private Map<Integer, List<EventHandler>> handlersByEventType;
    private List<EventHandler> anyHandler;
    private final MemoryChannel<Event> eventQueue;
    private final Fiber fiber;
    private volatile boolean isCloseCalled = false;
    private final Lane<String, ExecutorService> dispatcherLane;
    private Map<EventHandler, Disposable> disposableHandlerMap;

    public JetlangEventDispatcher(MemoryChannel<Event> eventQueue, Fiber fiber, Lane<String, ExecutorService> lane) {
        this.eventQueue = eventQueue;
        this.fiber = fiber;
        this.dispatcherLane = lane;
    }

    public JetlangEventDispatcher(Map<Integer, List<EventHandler>> listenersByEventType, List<EventHandler> anyHandler, MemoryChannel<Event> eventQueue, Fiber fiber, Lane<String, ExecutorService> lane) {
        this.handlersByEventType = listenersByEventType;
        this.anyHandler = anyHandler;
        this.eventQueue = eventQueue;
        this.fiber = fiber;
        this.dispatcherLane = lane;
    }

    public void initialize() {
        this.handlersByEventType = new HashMap<Integer, List<EventHandler>>(4);
        this.anyHandler = new CopyOnWriteArrayList<EventHandler>();
        this.disposableHandlerMap = new HashMap<EventHandler, Disposable>();
    }

    @Override
    public void fireEvent(Event event) {
        if (null != this.dispatcherLane && this.dispatcherLane.isOnSameLane(Thread.currentThread().getName())) {
            this.dispatchEventOnSameLane(event);
        } else {
            this.eventQueue.publish((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(final EventHandler eventHandler) {
        int eventType = eventHandler.getEventType();
        if (0 == eventType) {
            this.addANYHandler(eventHandler);
        } else {
            JetlangEventDispatcher jetlangEventDispatcher = this;
            synchronized (jetlangEventDispatcher) {
                List<EventHandler> listeners = this.handlersByEventType.get(eventType);
                if (listeners == null) {
                    listeners = new CopyOnWriteArrayList<EventHandler>();
                    this.handlersByEventType.put(eventType, listeners);
                }
                listeners.add(eventHandler);
                Callback<List<Event>> eventCallback = this.createEventCallbackForHandler(eventHandler);
                Filter<Event> eventFilter = new Filter<Event>(){

                    public boolean passes(Event msg) {
                        return eventHandler.getEventType() == msg.getType();
                    }
                };
                BatchSubscriber batchEventSubscriber = new BatchSubscriber(this.fiber, eventCallback, (Filter)eventFilter, 0, TimeUnit.MILLISECONDS);
                Disposable disposable = this.eventQueue.subscribe((Subscribable)batchEventSubscriber);
                this.disposableHandlerMap.put(eventHandler, disposable);
            }
        }
    }

    protected void addANYHandler(EventHandler eventHandler) {
        int eventType = eventHandler.getEventType();
        if (eventType != 0) {
            LOG.error("The incoming handler {} is not of type ANY", (Object)eventHandler);
            throw new IllegalArgumentException("The incoming handler is not of type ANY");
        }
        this.anyHandler.add(eventHandler);
        Callback<List<Event>> eventCallback = this.createEventCallbackForHandler(eventHandler);
        BatchSubscriber batchEventSubscriber = new BatchSubscriber(this.fiber, eventCallback, 0, TimeUnit.MILLISECONDS);
        Disposable disposable = this.eventQueue.subscribe((Subscribable)batchEventSubscriber);
        this.disposableHandlerMap.put(eventHandler, disposable);
    }

    protected Callback<List<Event>> createEventCallbackForHandler(final EventHandler eventHandler) {
        Callback<List<Event>> eventCallback = new Callback<List<Event>>(){

            public void onMessage(List<Event> messages) {
                for (Event event : messages) {
                    eventHandler.onEvent(event);
                }
            }
        };
        return eventCallback;
    }

    protected void dispatchEventOnSameLane(Event event) {
        for (EventHandler handler : this.anyHandler) {
            handler.onEvent(event);
        }
        List<EventHandler> handlers = this.handlersByEventType.get(event.getType());
        if (null != handlers) {
            for (EventHandler handler : handlers) {
                handler.onEvent(event);
            }
        }
    }

    @Override
    public synchronized List<EventHandler> getHandlers(int eventType) {
        if (0 == eventType) {
            return this.anyHandler;
        }
        return this.handlersByEventType.get(eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(EventHandler eventHandler) {
        int eventType = eventHandler.getEventType();
        if (0 == eventType) {
            this.anyHandler.remove(eventHandler);
        } else {
            JetlangEventDispatcher jetlangEventDispatcher = this;
            synchronized (jetlangEventDispatcher) {
                List<EventHandler> listeners = this.handlersByEventType.get(eventType);
                if (null != listeners) {
                    listeners.remove(eventHandler);
                }
            }
        }
        this.removeDisposableForHandler(eventHandler);
    }

    private synchronized void removeDisposableForHandler(EventHandler eventHandler) {
        Disposable disposable = this.disposableHandlerMap.get(eventHandler);
        if (null != disposable) {
            disposable.dispose();
            this.disposableHandlerMap.remove(eventHandler);
        }
    }

    @Override
    public synchronized void removeHandlersForEvent(int eventType) {
        List<EventHandler> handlers = null;
        handlers = 0 == eventType ? this.anyHandler : this.handlersByEventType.get(eventType);
        if (null != handlers) {
            for (EventHandler eventHandler : handlers) {
                this.removeDisposableForHandler(eventHandler);
            }
            handlers.clear();
        }
        this.handlersByEventType.put(eventType, null);
    }

    @Override
    public synchronized boolean removeHandlersForSession(Session session) {
        LOG.trace("Entered removeHandlersForSession for session {}", (Object)session);
        ArrayList<EventHandler> removeList = new ArrayList<EventHandler>();
        ArrayList<List<EventHandler>> eventHandlersList = new ArrayList<List<EventHandler>>(this.handlersByEventType.values());
        eventHandlersList.add(this.anyHandler);
        for (List list : eventHandlersList) {
            removeList.addAll(this.getHandlersToRemoveForSession(list, session));
        }
        LOG.trace("Going to remove {} handlers for session: {}", (Object)removeList.size(), (Object)session);
        for (EventHandler eventHandler : removeList) {
            this.removeHandler(eventHandler);
        }
        return removeList.size() > 0;
    }

    @Override
    public synchronized void clear() {
        LOG.trace("Going to clear handlers on dispatcher {}", (Object)this);
        if (null != this.handlersByEventType) {
            this.handlersByEventType.clear();
        }
        if (null != this.anyHandler) {
            this.anyHandler.clear();
        }
        Collection<Disposable> disposables = this.disposableHandlerMap.values();
        for (Disposable disposable : disposables) {
            disposable.dispose();
        }
        this.disposableHandlerMap.clear();
    }

    protected List<EventHandler> getHandlersToRemoveForSession(List<EventHandler> handlerList, Session session) {
        ArrayList<EventHandler> removeList = new ArrayList<EventHandler>();
        if (null != handlerList) {
            for (EventHandler handler : handlerList) {
                SessionEventHandler sessionHandler;
                if (!(handler instanceof SessionEventHandler) || !(sessionHandler = (SessionEventHandler)handler).getSession().equals(session)) continue;
                removeList.add(handler);
            }
        }
        return removeList;
    }

    @Override
    public synchronized void close() {
        if (!this.isCloseCalled) {
            this.fiber.dispose();
            this.eventQueue.clearSubscribers();
            Collection<Disposable> disposables = this.disposableHandlerMap.values();
            for (Disposable disposable : disposables) {
                disposable.dispose();
            }
            this.handlersByEventType.clear();
            this.handlersByEventType = null;
            this.anyHandler.clear();
            this.anyHandler = null;
            this.isCloseCalled = true;
        }
    }

    public Map<Integer, List<EventHandler>> getListenersByEventType() {
        return this.handlersByEventType;
    }

    public void setListenersByEventType(Map<Integer, List<EventHandler>> listenersByEventType) {
        this.handlersByEventType = listenersByEventType;
    }

    public MemoryChannel<Event> getEventQueue() {
        return this.eventQueue;
    }

    public Fiber getFiber() {
        return this.fiber;
    }

    public Map<EventHandler, Disposable> getDisposableHandlerMap() {
        return this.disposableHandlerMap;
    }

    public void setDisposableHandlerMap(Map<EventHandler, Disposable> disposableHandlerMap) {
        this.disposableHandlerMap = disposableHandlerMap;
    }
}

