/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.app.PlayerSession;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToServerHandler
extends SimpleChannelInboundHandler<Event> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultToServerHandler.class);
    private final PlayerSession playerSession;

    public DefaultToServerHandler(PlayerSession playerSession) {
        this.playerSession = playerSession;
    }

    public void channelRead0(ChannelHandlerContext ctx, Event msg) throws Exception {
        this.playerSession.onEvent(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception during network communication: {}.", cause);
        Event event = Events.event(cause, 36);
        this.playerSession.onEvent(event);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.debug("Netty Channel {} is closed.", (Object)ctx.channel());
        if (!this.playerSession.isShuttingDown()) {
            Event event = Events.event(null, 34);
            this.playerSession.onEvent(event);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOG.warn("Channel {} has been idle, exception event will be raised now: ", (Object)ctx.channel());
            Event event = Events.event(evt, 36);
            this.playerSession.onEvent(event);
        }
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }
}

