/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.event.Events;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;

public class EventObjectDecoder
extends LengthFieldBasedFrameDecoder {
    public EventObjectDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        super(maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        if (frame.readableBytes() > 0) {
            int opcode = frame.readByte();
            if (opcode == 29) {
                opcode = 28;
            }
            ByteBuf data = Unpooled.buffer((int)frame.readableBytes()).writeBytes(frame);
            Object obj = new SourceDecoder().decode(ctx, data);
            return Events.event(obj, opcode);
        }
        return null;
    }

    public static class SourceDecoder
    extends ObjectDecoder {
        public SourceDecoder() {
            super(ClassResolvers.cacheDisabled(null));
        }

        protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            return super.decode(ctx, in);
        }
    }
}

