/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.util.SmallFileReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashPolicyServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(FlashPolicyServerHandler.class);
    private static ByteBuf policyFile = null;
    private final String portNumber;
    private static final String NEWLINE = "\r\n";

    public String getPortNumber() {
        return this.portNumber;
    }

    public FlashPolicyServerHandler(String portNum) {
        this.portNumber = portNum;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        ChannelFuture f = null;
        f = null != policyFile ? ctx.channel().write((Object)policyFile) : ctx.channel().write((Object)this.getPolicyFileContents());
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public ByteBuf getPolicyFileContents() throws Exception {
        return Unpooled.copiedBuffer((CharSequence)("<?xml version=\"1.0\"?>\r\n<!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\">\r\n\r\n<!-- Policy file for xmlsocket://socks.example.com -->\r\n<cross-domain-policy> \r\n\r\n   <!-- This is a master socket policy file -->\r\n   <!-- No other socket policies on the host will be permitted -->\r\n   <site-control permitted-cross-domain-policies=\"master-only\"/>\r\n\r\n   <!-- Instead of setting to-ports=\"*\", administrator's can use ranges and commas -->\r\n   <allow-access-from domain=\"*\" to-ports=\"" + this.portNumber + "\" />" + NEWLINE + "" + NEWLINE + "</cross-domain-policy>" + NEWLINE), (Charset)CharsetUtil.US_ASCII);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ReadTimeoutException) {
            LOG.error("Connection timed out. Going to close channel");
        } else {
            LOG.error("Exception in FlashPolicyFileHanlder", cause);
        }
        ctx.channel().close();
    }

    static {
        String filePath = System.getProperty("flash_policy_file_path");
        if (null != filePath) {
            try {
                String fileContents = SmallFileReader.readSmallFile(filePath);
                policyFile = Unpooled.copiedBuffer((byte[])fileContents.getBytes());
            }
            catch (IOException e) {
                LOG.error("Unable to open flash policy file", (Throwable)e);
            }
        }
    }
}

