/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.app.GameRoom;
import io.nadron.app.Player;
import io.nadron.app.PlayerSession;
import io.nadron.app.Session;
import io.nadron.communication.NettyTCPMessageSender;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.nadron.event.impl.ReconnetEvent;
import io.nadron.server.netty.AbstractNettyServer;
import io.nadron.service.LookupService;
import io.nadron.service.SessionRegistryService;
import io.nadron.service.UniqueIDGeneratorService;
import io.nadron.service.impl.ReconnectSessionRegistry;
import io.nadron.util.NettyUtils;
import io.nadron.util.SimpleCredentials;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class LoginHandler
extends SimpleChannelInboundHandler<Event> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginHandler.class);
    protected LookupService lookupService;
    protected SessionRegistryService<SocketAddress> udpSessionRegistry;
    protected ReconnectSessionRegistry reconnectRegistry;
    protected UniqueIDGeneratorService idGeneratorService;
    private static final AtomicInteger CHANNEL_COUNTER = new AtomicInteger(0);

    public void channelRead0(ChannelHandlerContext ctx, Event event) throws Exception {
        ByteBuf buffer = (ByteBuf)event.getSource();
        Channel channel = ctx.channel();
        int type = event.getType();
        if (8 == type) {
            LOG.debug("Login attempt from {}", (Object)channel.remoteAddress());
            Player player = this.lookupPlayer(buffer, channel);
            this.handleLogin(player, ctx, buffer);
        } else if (3 == type) {
            LOG.debug("Reconnect attempt from {}", (Object)channel.remoteAddress());
            String reconnectKey = NettyUtils.readString(buffer);
            PlayerSession playerSession = this.lookupSession(reconnectKey);
            this.handleReconnect(playerSession, ctx, buffer);
        } else {
            LOG.error("Invalid event {} sent from remote address {}. Going to close channel {}", new Object[]{event.getType(), channel.remoteAddress(), channel});
            this.closeChannelWithLoginFailure(channel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        LOG.error("Exception {} occurred during log in process, going to close channel {}", (Object)cause, (Object)channel);
        channel.close();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        AbstractNettyServer.ALL_CHANNELS.add((Object)ctx.channel());
        LOG.debug("Added Channel {} as the {}th open channel", (Object)ctx.channel(), (Object)CHANNEL_COUNTER.incrementAndGet());
    }

    public Player lookupPlayer(ByteBuf buffer, Channel channel) {
        SimpleCredentials credentials = new SimpleCredentials(buffer);
        Player player = this.lookupService.playerLookup(credentials);
        if (null == player) {
            LOG.error("Invalid credentials provided by user: {}", (Object)credentials);
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerSession lookupSession(String reconnectKey) {
        PlayerSession playerSession = (PlayerSession)this.reconnectRegistry.getSession(reconnectKey);
        if (null != playerSession) {
            PlayerSession playerSession2 = playerSession;
            synchronized (playerSession2) {
                if (playerSession.getStatus() == Session.Status.NOT_CONNECTED) {
                    playerSession.setStatus(Session.Status.CONNECTING);
                } else {
                    playerSession = null;
                }
            }
        }
        return playerSession;
    }

    public void handleLogin(Player player, ChannelHandlerContext ctx, ByteBuf buffer) {
        if (null != player) {
            ctx.channel().write((Object)NettyUtils.createBufferForOpcode(11));
            this.handleGameRoomJoin(player, ctx, buffer);
        } else {
            this.closeChannelWithLoginFailure(ctx.channel());
        }
    }

    protected void handleReconnect(PlayerSession playerSession, ChannelHandlerContext ctx, ByteBuf buffer) {
        if (null != playerSession) {
            ctx.write((Object)NettyUtils.createBufferForOpcode(11));
            GameRoom gameRoom = playerSession.getGameRoom();
            gameRoom.disconnectSession(playerSession);
            if (null != playerSession.getTcpSender()) {
                playerSession.getTcpSender().close();
            }
            if (null != playerSession.getUdpSender()) {
                playerSession.getUdpSender().close();
            }
            this.handleReJoin(playerSession, gameRoom, ctx.channel(), buffer);
        } else {
            this.closeChannelWithLoginFailure(ctx.channel());
        }
    }

    private void closeChannelWithLoginFailure(Channel channel) {
        ChannelFuture future = channel.writeAndFlush((Object)NettyUtils.createBufferForOpcode(12));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void handleGameRoomJoin(Player player, ChannelHandlerContext ctx, ByteBuf buffer) {
        String refKey = NettyUtils.readString(buffer);
        Channel channel = ctx.channel();
        GameRoom gameRoom = this.lookupService.gameRoomLookup(refKey);
        if (null != gameRoom) {
            PlayerSession playerSession = gameRoom.createPlayerSession(player);
            String reconnectKey = (String)this.idGeneratorService.generateFor(playerSession.getClass());
            playerSession.setAttribute("RECONNECT_KEY", reconnectKey);
            playerSession.setAttribute("RECONNECT_REGISTRY", this.reconnectRegistry);
            LOG.trace("Sending GAME_ROOM_JOIN_SUCCESS to channel {}", (Object)channel);
            ByteBuf reconnectKeyBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{NettyUtils.createBufferForOpcode(24), NettyUtils.writeString(reconnectKey)});
            ChannelFuture future = channel.writeAndFlush((Object)reconnectKeyBuffer);
            this.connectToGameRoom(gameRoom, playerSession, future);
            this.loginUdp(playerSession, buffer);
        } else {
            ChannelFuture future = channel.writeAndFlush((Object)NettyUtils.createBufferForOpcode(25));
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            LOG.error("Invalid ref key provided by client: {}. Channel {} will be closed", (Object)refKey, (Object)channel);
        }
    }

    protected void handleReJoin(PlayerSession playerSession, GameRoom gameRoom, Channel channel, ByteBuf buffer) {
        LOG.trace("Going to clear pipeline");
        NettyUtils.clearPipeline(channel.pipeline());
        NettyTCPMessageSender sender = new NettyTCPMessageSender(channel);
        playerSession.setTcpSender(sender);
        gameRoom.connectSession(playerSession);
        playerSession.setWriteable(true);
        playerSession.onEvent(new ReconnetEvent(sender));
        this.loginUdp(playerSession, buffer);
    }

    public void connectToGameRoom(final GameRoom gameRoom, final PlayerSession playerSession, ChannelFuture future) {
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel channel = future.channel();
                LOG.trace("Sending GAME_ROOM_JOIN_SUCCESS to channel {} completed", (Object)channel);
                if (future.isSuccess()) {
                    LOG.trace("Going to clear pipeline");
                    NettyUtils.clearPipeline(channel.pipeline());
                    NettyTCPMessageSender tcpSender = new NettyTCPMessageSender(channel);
                    playerSession.setTcpSender(tcpSender);
                    gameRoom.connectSession(playerSession);
                    tcpSender.sendMessage(Events.event(null, 26));
                    gameRoom.onLogin(playerSession);
                } else {
                    LOG.error("GAME_ROOM_JOIN_SUCCESS message sending to client was failure, channel will be closed");
                    channel.close();
                }
            }
        });
    }

    protected void loginUdp(PlayerSession playerSession, ByteBuf buffer) {
        InetSocketAddress remoteAddress = NettyUtils.readSocketAddress(buffer);
        if (null != remoteAddress) {
            this.udpSessionRegistry.putSession(remoteAddress, playerSession);
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public UniqueIDGeneratorService getIdGeneratorService() {
        return this.idGeneratorService;
    }

    public void setIdGeneratorService(UniqueIDGeneratorService idGeneratorService) {
        this.idGeneratorService = idGeneratorService;
    }

    public SessionRegistryService<SocketAddress> getUdpSessionRegistry() {
        return this.udpSessionRegistry;
    }

    public void setUdpSessionRegistry(SessionRegistryService<SocketAddress> udpSessionRegistry) {
        this.udpSessionRegistry = udpSessionRegistry;
    }

    public ReconnectSessionRegistry getReconnectRegistry() {
        return this.reconnectRegistry;
    }

    public void setReconnectRegistry(ReconnectSessionRegistry reconnectRegistry) {
        this.reconnectRegistry = reconnectRegistry;
    }
}

