/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.handlers.netty.EventDecoder;
import io.nadron.handlers.netty.LoginHandler;
import io.nadron.handlers.netty.WebSocketLoginHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.List;

public interface LoginProtocol {
    public static final String LOGIN_HANDLER_NAME = "loginHandler";

    public boolean applyProtocol(ByteBuf var1, ChannelPipeline var2);

    public static class CompositeProtocol
    implements LoginProtocol {
        private List<LoginProtocol> protocols;

        @Override
        public boolean applyProtocol(ByteBuf buffer, ChannelPipeline pipeline) {
            if (null != this.protocols) {
                for (LoginProtocol protocol : this.protocols) {
                    if (!protocol.applyProtocol(buffer, pipeline)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<LoginProtocol> getProtocols() {
            return this.protocols;
        }

        public void setProtocols(List<LoginProtocol> protocols) {
            this.protocols = protocols;
        }
    }

    public static class DefaultNadProtocol
    implements LoginProtocol {
        private int frameSize = 1024;
        private EventDecoder eventDecoder;
        private LoginHandler loginHandler;
        private LengthFieldPrepender lengthFieldPrepender;

        @Override
        public boolean applyProtocol(ByteBuf buffer, ChannelPipeline pipeline) {
            short protocolVersion;
            boolean isThisProtocol = false;
            short opcode = buffer.getUnsignedByte(buffer.readerIndex() + 2);
            if (this.isNadProtocol(opcode, protocolVersion = buffer.getUnsignedByte(buffer.readerIndex() + 3))) {
                pipeline.addLast("framer", this.createLengthBasedFrameDecoder());
                pipeline.addLast("eventDecoder", (ChannelHandler)this.eventDecoder);
                pipeline.addLast(LoginProtocol.LOGIN_HANDLER_NAME, (ChannelHandler)this.loginHandler);
                pipeline.addLast("lengthFieldPrepender", (ChannelHandler)this.lengthFieldPrepender);
                isThisProtocol = true;
            }
            return isThisProtocol;
        }

        protected boolean isNadProtocol(int magic1, int magic2) {
            return (magic1 == 8 || magic1 == 3) && magic2 == 1;
        }

        public ChannelHandler createLengthBasedFrameDecoder() {
            return new LengthFieldBasedFrameDecoder(this.frameSize, 0, 2, 0, 2);
        }

        public int getFrameSize() {
            return this.frameSize;
        }

        public void setFrameSize(int frameSize) {
            this.frameSize = frameSize;
        }

        public EventDecoder getEventDecoder() {
            return this.eventDecoder;
        }

        public void setEventDecoder(EventDecoder eventDecoder) {
            this.eventDecoder = eventDecoder;
        }

        public LoginHandler getLoginHandler() {
            return this.loginHandler;
        }

        public void setLoginHandler(LoginHandler loginHandler) {
            this.loginHandler = loginHandler;
        }

        public LengthFieldPrepender getLengthFieldPrepender() {
            return this.lengthFieldPrepender;
        }

        public void setLengthFieldPrepender(LengthFieldPrepender lengthFieldPrepender) {
            this.lengthFieldPrepender = lengthFieldPrepender;
        }
    }

    public static class HTTPProtocol
    implements LoginProtocol {
        private WebSocketLoginHandler webSocketLoginHandler;

        @Override
        public boolean applyProtocol(ByteBuf buffer, ChannelPipeline pipeline) {
            short magic2;
            boolean isThisProtocol = false;
            short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
            if (this.isHttp(magic1, magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1))) {
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("handler", (ChannelHandler)new WebSocketServerProtocolHandler("/nadsocket"));
                pipeline.addLast(LoginProtocol.LOGIN_HANDLER_NAME, (ChannelHandler)this.webSocketLoginHandler);
                isThisProtocol = true;
            }
            return isThisProtocol;
        }

        protected boolean isHttp(int magic1, int magic2) {
            return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
        }

        public WebSocketLoginHandler getWebSocketLoginHandler() {
            return this.webSocketLoginHandler;
        }

        public void setWebSocketLoginHandler(WebSocketLoginHandler webSocketLoginHandler) {
            this.webSocketLoginHandler = webSocketLoginHandler;
        }
    }
}

