/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.communication.NettyMessageBuffer;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

@ChannelHandler.Sharable
public class MessageBufferEventDecoder
extends MessageToMessageDecoder<ByteBuf> {
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        out.add(this.decode(ctx, buffer));
    }

    public Event decode(ChannelHandlerContext ctx, ByteBuf buffer) {
        int opcode = buffer.readByte();
        if (opcode == 29) {
            opcode = 28;
        }
        ByteBuf data = Unpooled.buffer((int)buffer.readableBytes()).writeBytes(buffer);
        return Events.event(new NettyMessageBuffer(data), opcode);
    }
}

