/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.handlers.netty.LoginProtocol;
import io.nadron.util.BinaryUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolMultiplexerDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolMultiplexerDecoder.class);
    private final LoginProtocol loginProtocol;
    private final int bytesForProtocolCheck;

    public ProtocolMultiplexerDecoder(int bytesForProtocolCheck, LoginProtocol loginProtocol) {
        this.loginProtocol = loginProtocol;
        this.bytesForProtocolCheck = bytesForProtocolCheck;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < this.bytesForProtocolCheck) {
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        if (!this.loginProtocol.applyProtocol(in, pipeline)) {
            byte[] headerBytes = new byte[this.bytesForProtocolCheck];
            in.getBytes(in.readerIndex(), headerBytes, 0, this.bytesForProtocolCheck);
            LOG.error("Unknown protocol, discard everything and close the connection {}. Incoming Bytes {}", (Object)ctx.channel(), (Object)BinaryUtils.getHexString(headerBytes));
            this.close(in, ctx);
        } else {
            pipeline.remove((ChannelHandler)this);
        }
    }

    protected void close(ByteBuf buffer, ChannelHandlerContext ctx) {
        buffer.clear();
        ctx.close();
    }

    public LoginProtocol getLoginProtocol() {
        return this.loginProtocol;
    }

    public int getBytesForProtocolCheck() {
        return this.bytesForProtocolCheck;
    }
}

