/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.event.Event;
import io.nadron.event.impl.DefaultEvent;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

@ChannelHandler.Sharable
public class TextWebsocketDecoder
extends MessageToMessageDecoder<TextWebSocketFrame> {
    private ObjectMapper jackson;
    private final AttributeKey<Class<? extends Event>> eventClass = new AttributeKey("eventClass");

    protected void decode(ChannelHandlerContext ctx, TextWebSocketFrame frame, List<Object> out) throws Exception {
        Attribute attr = ctx.attr(this.eventClass);
        Class<DefaultEvent> theClass = (Class<DefaultEvent>)attr.get();
        boolean unknownClass = false;
        if (null == theClass) {
            unknownClass = true;
            theClass = DefaultEvent.class;
        }
        String json = frame.text();
        Event event = (Event)this.jackson.readValue(json, theClass);
        if (unknownClass) {
            String cName = ((DefaultEvent)event).getcName();
            if (null == cName) {
                attr.set(DefaultEvent.class);
            } else {
                Class<?> newClass = Class.forName(cName);
                event = (Event)this.jackson.readValue(json, newClass);
                attr.set(newClass);
            }
        }
        if (event.getType() == 29) {
            event.setType(28);
        }
        out.add(event);
    }

    public ObjectMapper getJackson() {
        return this.jackson;
    }

    public void setJackson(ObjectMapper jackson) {
        this.jackson = jackson;
    }
}

