/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.app.Session;
import io.nadron.communication.NettyUDPMessageSender;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.nadron.handlers.netty.MessageBufferEventDecoder;
import io.nadron.service.SessionRegistryService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPUpstreamHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(UDPUpstreamHandler.class);
    private static final String UDP_CONNECTING = "UDP_CONNECTING";
    private SessionRegistryService<SocketAddress> udpSessionRegistry;
    private MessageBufferEventDecoder messageBufferEventDecoder;

    public void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        SocketAddress remoteAddress = packet.sender();
        Session session = this.udpSessionRegistry.getSession(remoteAddress);
        if (null != session) {
            ByteBuf buffer = (ByteBuf)packet.content();
            Event event = this.messageBufferEventDecoder.decode(null, buffer);
            if (!session.isUDPEnabled()) {
                if (null == session.getAttribute(UDP_CONNECTING) || !((Boolean)session.getAttribute(UDP_CONNECTING)).booleanValue()) {
                    session.setAttribute(UDP_CONNECTING, true);
                    event = this.getUDPConnectEvent(event, remoteAddress, (DatagramChannel)ctx.channel());
                    session.onEvent(event);
                } else {
                    LOG.info("Going to discard UDP Message Event with type {} the UDP MessageSender is not initialized fully", (Object)event.getType());
                }
            } else if (event.getType() == 2) {
                LOG.trace("Duplicate CONNECT {} received in UDP channel, for session: {} going to discard", (Object)event, (Object)session);
            } else {
                session.onEvent(event);
            }
        } else {
            LOG.trace("Packet received from unknown source address: {}, going to discard", (Object)remoteAddress);
        }
    }

    public Event getUDPConnectEvent(Event event, SocketAddress remoteAddress, DatagramChannel udpChannel) {
        LOG.debug("Incoming udp connection remote address : {}", (Object)remoteAddress);
        if (event.getType() != 2) {
            LOG.info("UDP Event with type {} will get converted to a CONNECT event since the UDP MessageSender is not initialized till now", (Object)event.getType());
        }
        NettyUDPMessageSender messageSender = new NettyUDPMessageSender(remoteAddress, udpChannel, this.udpSessionRegistry);
        Event connectEvent = Events.connectEvent(messageSender);
        return connectEvent;
    }

    public SessionRegistryService<SocketAddress> getUdpSessionRegistry() {
        return this.udpSessionRegistry;
    }

    public void setUdpSessionRegistry(SessionRegistryService<SocketAddress> udpSessionRegistry) {
        this.udpSessionRegistry = udpSessionRegistry;
    }

    public MessageBufferEventDecoder getMessageBufferEventDecoder() {
        return this.messageBufferEventDecoder;
    }

    public void setMessageBufferEventDecoder(MessageBufferEventDecoder messageBufferEventDecoder) {
        this.messageBufferEventDecoder = messageBufferEventDecoder;
    }
}

