/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.handlers.netty;

import io.nadron.app.GameRoom;
import io.nadron.app.Player;
import io.nadron.app.PlayerSession;
import io.nadron.app.Session;
import io.nadron.communication.NettyTCPMessageSender;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.nadron.event.impl.DefaultEvent;
import io.nadron.event.impl.ReconnetEvent;
import io.nadron.service.LookupService;
import io.nadron.service.UniqueIDGeneratorService;
import io.nadron.service.impl.ReconnectSessionRegistry;
import io.nadron.util.SimpleCredentials;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketLoginHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketLoginHandler.class);
    private LookupService lookupService;
    protected ReconnectSessionRegistry reconnectRegistry;
    protected UniqueIDGeneratorService idGeneratorService;
    private ObjectMapper jackson;

    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame frame) throws Exception {
        Channel channel = ctx.channel();
        String data = frame.text();
        LOG.trace("From websocket: " + data);
        Event event = (Event)this.jackson.readValue(data, DefaultEvent.class);
        int type = event.getType();
        if (8 == type) {
            LOG.trace("Login attempt from {}", (Object)channel.remoteAddress());
            List credList = null;
            credList = (List)event.getSource();
            Player player = this.lookupPlayer((String)credList.get(0), (String)credList.get(1));
            this.handleLogin(player, channel);
            this.handleGameRoomJoin(player, channel, (String)credList.get(2));
        } else if (type == 3) {
            LOG.debug("Reconnect attempt from {}", (Object)channel.remoteAddress());
            PlayerSession playerSession = this.lookupSession((String)event.getSource());
            this.handleReconnect(playerSession, channel);
        } else {
            LOG.error("Invalid event {} sent from remote address {}. Going to close channel {}", new Object[]{event.getType(), channel.remoteAddress(), channel});
            this.closeChannelWithLoginFailure(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerSession lookupSession(String reconnectKey) {
        PlayerSession playerSession = (PlayerSession)this.reconnectRegistry.getSession(reconnectKey);
        if (null != playerSession) {
            PlayerSession playerSession2 = playerSession;
            synchronized (playerSession2) {
                if (playerSession.getStatus() == Session.Status.NOT_CONNECTED) {
                    playerSession.setStatus(Session.Status.CONNECTING);
                } else {
                    playerSession = null;
                }
            }
        }
        return playerSession;
    }

    protected void handleReconnect(PlayerSession playerSession, Channel channel) throws Exception {
        if (null != playerSession) {
            channel.writeAndFlush((Object)this.eventToFrame((byte)11, null));
            GameRoom gameRoom = playerSession.getGameRoom();
            gameRoom.disconnectSession(playerSession);
            if (null != playerSession.getTcpSender()) {
                playerSession.getTcpSender().close();
            }
            this.handleReJoin(playerSession, gameRoom, channel);
        } else {
            this.closeChannelWithLoginFailure(channel);
        }
    }

    protected void handleReJoin(PlayerSession playerSession, GameRoom gameRoom, Channel channel) {
        NettyTCPMessageSender sender = new NettyTCPMessageSender(channel);
        playerSession.setTcpSender(sender);
        gameRoom.connectSession(playerSession);
        channel.writeAndFlush((Object)24, null);
        playerSession.setWriteable(true);
        playerSession.onEvent(new ReconnetEvent(sender));
    }

    public Player lookupPlayer(String username, String password) throws Exception {
        SimpleCredentials credentials = new SimpleCredentials(username, password);
        Player player = this.lookupService.playerLookup(credentials);
        if (null == player) {
            LOG.error("Invalid credentials provided by user: {}", (Object)credentials);
        }
        return player;
    }

    public void handleLogin(Player player, Channel channel) throws Exception {
        if (null != player) {
            channel.writeAndFlush((Object)this.eventToFrame((byte)11, null));
        } else {
            this.closeChannelWithLoginFailure(channel);
        }
    }

    protected void closeChannelWithLoginFailure(Channel channel) throws Exception {
        channel.writeAndFlush((Object)this.eventToFrame((byte)12, null)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void handleGameRoomJoin(Player player, Channel channel, String refKey) throws Exception {
        GameRoom gameRoom = this.lookupService.gameRoomLookup(refKey);
        if (null != gameRoom) {
            PlayerSession playerSession = gameRoom.createPlayerSession(player);
            String reconnectKey = (String)this.idGeneratorService.generateFor(playerSession.getClass());
            playerSession.setAttribute("RECONNECT_KEY", reconnectKey);
            playerSession.setAttribute("RECONNECT_REGISTRY", this.reconnectRegistry);
            LOG.trace("Sending GAME_ROOM_JOIN_SUCCESS to channel {}", (Object)channel);
            ChannelFuture future = channel.writeAndFlush((Object)this.eventToFrame((byte)24, reconnectKey));
            this.connectToGameRoom(gameRoom, playerSession, future);
        } else {
            ChannelFuture future = channel.writeAndFlush((Object)this.eventToFrame((byte)25, null));
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            LOG.error("Invalid ref key provided by client: {}. Channel {} will be closed", (Object)refKey, (Object)channel);
        }
    }

    public void connectToGameRoom(final GameRoom gameRoom, final PlayerSession playerSession, ChannelFuture future) {
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel channel = future.channel();
                LOG.trace("Sending GAME_ROOM_JOIN_SUCCESS to channel {} completed", (Object)channel);
                if (future.isSuccess()) {
                    NettyTCPMessageSender tcpSender = new NettyTCPMessageSender(channel);
                    playerSession.setTcpSender(tcpSender);
                    gameRoom.connectSession(playerSession);
                    tcpSender.sendMessage(Events.event(null, 26));
                    gameRoom.onLogin(playerSession);
                } else {
                    LOG.error("Sending GAME_ROOM_JOIN_SUCCESS message to client was failure, channel will be closed");
                    channel.close();
                }
            }
        });
    }

    protected TextWebSocketFrame eventToFrame(byte opcode, Object payload) throws Exception {
        Event event = Events.event(payload, opcode);
        return new TextWebSocketFrame(this.jackson.writeValueAsString((Object)event));
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public ReconnectSessionRegistry getReconnectRegistry() {
        return this.reconnectRegistry;
    }

    public void setReconnectRegistry(ReconnectSessionRegistry reconnectRegistry) {
        this.reconnectRegistry = reconnectRegistry;
    }

    public UniqueIDGeneratorService getIdGeneratorService() {
        return this.idGeneratorService;
    }

    public void setIdGeneratorService(UniqueIDGeneratorService idGeneratorService) {
        this.idGeneratorService = idGeneratorService;
    }

    public ObjectMapper getJackson() {
        return this.jackson;
    }

    public void setJackson(ObjectMapper jackson) {
        this.jackson = jackson;
    }
}

