/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols;

import io.nadron.app.PlayerSession;
import io.nadron.protocols.Protocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public abstract class AbstractNettyProtocol
implements Protocol {
    final String protocolName;
    public static final String IDLE_STATE_CHECK_HANDLER = "idleStateCheck";

    public AbstractNettyProtocol(String protocolName) {
        this.protocolName = protocolName;
    }

    public LengthFieldBasedFrameDecoder createLengthBasedFrameDecoder() {
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 2, 0, 2);
    }

    @Override
    public String getProtocolName() {
        return this.protocolName;
    }

    @Override
    public void applyProtocol(PlayerSession playerSession, boolean clearExistingProtocolHandlers) {
        if (clearExistingProtocolHandlers) {
            ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
            NettyUtils.clearPipeline(pipeline);
        }
        this.applyProtocol(playerSession);
    }
}

