/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.AMF3ToJavaObjectDecoder;
import io.nadron.handlers.netty.DefaultToServerHandler;
import io.nadron.handlers.netty.JavaObjectToAMF3Encoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldPrepender;

public class AMF3Protocol
extends AbstractNettyProtocol {
    private JavaObjectToAMF3Encoder javaObjectToAMF3Encoder;
    private LengthFieldPrepender lengthFieldPrepender;

    public AMF3Protocol() {
        super("AMF3");
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("lengthDecoder", (ChannelHandler)this.createLengthBasedFrameDecoder());
        pipeline.addLast("amf3ToJavaObjectDecoder", (ChannelHandler)this.createAMF3ToJavaObjectDecoder());
        pipeline.addLast("eventHandler", (ChannelHandler)new DefaultToServerHandler(playerSession));
        pipeline.addLast("lengthFieldPrepender", (ChannelHandler)this.lengthFieldPrepender);
        pipeline.addLast("javaObjectToAMF3Encoder", (ChannelHandler)this.javaObjectToAMF3Encoder);
    }

    protected AMF3ToJavaObjectDecoder createAMF3ToJavaObjectDecoder() {
        return new AMF3ToJavaObjectDecoder();
    }

    public JavaObjectToAMF3Encoder getJavaObjectToAMF3Encoder() {
        return this.javaObjectToAMF3Encoder;
    }

    public void setJavaObjectToAMF3Encoder(JavaObjectToAMF3Encoder javaObjectToAMF3Encoder) {
        this.javaObjectToAMF3Encoder = javaObjectToAMF3Encoder;
    }

    public LengthFieldPrepender getLengthFieldPrepender() {
        return this.lengthFieldPrepender;
    }

    public void setLengthFieldPrepender(LengthFieldPrepender lengthFieldPrepender) {
        this.lengthFieldPrepender = lengthFieldPrepender;
    }
}

