/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.AMF3ToJavaObjectDecoder;
import io.nadron.handlers.netty.JavaObjectToAMF3Encoder;
import io.nadron.handlers.netty.NulEncoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.base64.Base64Decoder;
import io.netty.handler.codec.base64.Base64Encoder;

public class AMF3StringProtocol
extends AbstractNettyProtocol {
    int maxFrameSize;
    private Base64Decoder base64Decoder;
    private JavaObjectToAMF3Encoder javaObjectToAMF3Encoder;
    private Base64Encoder base64Encoder;
    private NulEncoder nulEncoder;

    public AMF3StringProtocol() {
        super("AMF3_STRING");
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(this.maxFrameSize, Delimiters.nulDelimiter()));
        pipeline.addLast("base64Decoder", (ChannelHandler)this.base64Decoder);
        pipeline.addLast("amf3ToJavaObjectDecoder", (ChannelHandler)this.createAMF3ToJavaObjectDecoder());
        pipeline.addLast("nulEncoder", (ChannelHandler)this.nulEncoder);
        pipeline.addLast("base64Encoder", (ChannelHandler)this.base64Encoder);
        pipeline.addLast("javaObjectToAMF3Encoder", (ChannelHandler)this.javaObjectToAMF3Encoder);
    }

    protected AMF3ToJavaObjectDecoder createAMF3ToJavaObjectDecoder() {
        return new AMF3ToJavaObjectDecoder();
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int frameSize) {
        this.maxFrameSize = frameSize;
    }

    public Base64Decoder getBase64Decoder() {
        return this.base64Decoder;
    }

    public void setBase64Decoder(Base64Decoder base64Decoder) {
        this.base64Decoder = base64Decoder;
    }

    public JavaObjectToAMF3Encoder getJavaObjectToAMF3Encoder() {
        return this.javaObjectToAMF3Encoder;
    }

    public void setJavaObjectToAMF3Encoder(JavaObjectToAMF3Encoder javaObjectToAMF3Encoder) {
        this.javaObjectToAMF3Encoder = javaObjectToAMF3Encoder;
    }

    public Base64Encoder getBase64Encoder() {
        return this.base64Encoder;
    }

    public void setBase64Encoder(Base64Encoder base64Encoder) {
        this.base64Encoder = base64Encoder;
    }

    public NulEncoder getNulEncoder() {
        return this.nulEncoder;
    }

    public void setNulEncoder(NulEncoder nulEncoder) {
        this.nulEncoder = nulEncoder;
    }
}

