/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.DefaultToServerHandler;
import io.nadron.handlers.netty.EventDecoder;
import io.nadron.handlers.netty.EventEncoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldPrepender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBufferProtocol
extends AbstractNettyProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelBufferProtocol.class);
    private LengthFieldPrepender lengthFieldPrepender;
    private EventDecoder eventDecoder;
    private EventEncoder eventEncoder;

    public ChannelBufferProtocol() {
        super("CHANNEL_BUFFER_PROTOCOL");
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        LOG.trace("Going to apply {} on session: {}", (Object)this.getProtocolName(), (Object)playerSession);
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("lengthDecoder", (ChannelHandler)this.createLengthBasedFrameDecoder());
        pipeline.addLast("eventDecoder", (ChannelHandler)this.eventDecoder);
        pipeline.addLast("eventHandler", (ChannelHandler)new DefaultToServerHandler(playerSession));
        pipeline.addLast("lengthFieldPrepender", (ChannelHandler)this.lengthFieldPrepender);
        pipeline.addLast("eventEncoder", (ChannelHandler)this.eventEncoder);
    }

    public LengthFieldPrepender getLengthFieldPrepender() {
        return this.lengthFieldPrepender;
    }

    public void setLengthFieldPrepender(LengthFieldPrepender lengthFieldPrepender) {
        this.lengthFieldPrepender = lengthFieldPrepender;
    }

    public EventDecoder getEventDecoder() {
        return this.eventDecoder;
    }

    public void setEventDecoder(EventDecoder eventDecoder) {
        this.eventDecoder = eventDecoder;
    }

    public EventEncoder getEventEncoder() {
        return this.eventEncoder;
    }

    public void setEventEncoder(EventEncoder eventEncoder) {
        this.eventEncoder = eventEncoder;
    }
}

