/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.DefaultToServerHandler;
import io.nadron.handlers.netty.MessageBufferEventDecoder;
import io.nadron.handlers.netty.MessageBufferEventEncoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldPrepender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBufferProtocol
extends AbstractNettyProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBufferProtocol.class);
    private LengthFieldPrepender lengthFieldPrepender;
    private MessageBufferEventDecoder messageBufferEventDecoder;
    private MessageBufferEventEncoder messageBufferEventEncoder;

    public MessageBufferProtocol() {
        super("MESSAGE_BUFFER_PROTOCOL");
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        LOG.trace("Going to apply {} on session: {}", (Object)this.getProtocolName(), (Object)playerSession);
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("lengthDecoder", (ChannelHandler)this.createLengthBasedFrameDecoder());
        pipeline.addLast("messageBufferEventDecoder", (ChannelHandler)this.messageBufferEventDecoder);
        pipeline.addLast("eventHandler", (ChannelHandler)new DefaultToServerHandler(playerSession));
        pipeline.addLast("lengthFieldPrepender", (ChannelHandler)this.lengthFieldPrepender);
        pipeline.addLast("messageBufferEventEncoder", (ChannelHandler)this.messageBufferEventEncoder);
    }

    public LengthFieldPrepender getLengthFieldPrepender() {
        return this.lengthFieldPrepender;
    }

    public void setLengthFieldPrepender(LengthFieldPrepender lengthFieldPrepender) {
        this.lengthFieldPrepender = lengthFieldPrepender;
    }

    public MessageBufferEventDecoder getMessageBufferEventDecoder() {
        return this.messageBufferEventDecoder;
    }

    public void setMessageBufferEventDecoder(MessageBufferEventDecoder messageBufferEventDecoder) {
        this.messageBufferEventDecoder = messageBufferEventDecoder;
    }

    public MessageBufferEventEncoder getMessageBufferEventEncoder() {
        return this.messageBufferEventEncoder;
    }

    public void setMessageBufferEventEncoder(MessageBufferEventEncoder messageBufferEventEncoder) {
        this.messageBufferEventEncoder = messageBufferEventEncoder;
    }
}

