/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.NulEncoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import org.springframework.beans.factory.annotation.Required;

public class StringProtocol
extends AbstractNettyProtocol {
    int frameSize;
    private NulEncoder nulEncoder;
    private StringDecoder stringDecoder;
    private StringEncoder stringEncoder;

    public StringProtocol() {
        super("STRING_PROTOCOL");
    }

    public StringProtocol(int frameSize, NulEncoder nulEncoder, StringDecoder stringDecoder, StringEncoder stringEncoder) {
        super("STRING_PROTOCOL");
        this.frameSize = frameSize;
        this.nulEncoder = nulEncoder;
        this.stringDecoder = stringDecoder;
        this.stringEncoder = stringEncoder;
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(this.frameSize, Delimiters.nulDelimiter()));
        pipeline.addLast("stringDecoder", (ChannelHandler)this.stringDecoder);
        pipeline.addLast("nulEncoder", (ChannelHandler)this.nulEncoder);
        pipeline.addLast("stringEncoder", (ChannelHandler)this.stringEncoder);
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    @Required
    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public NulEncoder getNulEncoder() {
        return this.nulEncoder;
    }

    @Required
    public void setNulEncoder(NulEncoder nulEncoder) {
        this.nulEncoder = nulEncoder;
    }

    public StringDecoder getStringDecoder() {
        return this.stringDecoder;
    }

    @Required
    public void setStringDecoder(StringDecoder stringDecoder) {
        this.stringDecoder = stringDecoder;
    }

    public StringEncoder getStringEncoder() {
        return this.stringEncoder;
    }

    @Required
    public void setStringEncoder(StringEncoder stringEncoder) {
        this.stringEncoder = stringEncoder;
    }
}

