/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.protocols.impl;

import io.nadron.app.PlayerSession;
import io.nadron.handlers.netty.DefaultToServerHandler;
import io.nadron.handlers.netty.TextWebsocketDecoder;
import io.nadron.handlers.netty.TextWebsocketEncoder;
import io.nadron.protocols.AbstractNettyProtocol;
import io.nadron.util.NettyUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProtocol
extends AbstractNettyProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketProtocol.class);
    private TextWebsocketDecoder textWebsocketDecoder;
    private TextWebsocketEncoder textWebsocketEncoder;

    public WebSocketProtocol() {
        super("WEB_SOCKET_PROTOCOL");
    }

    @Override
    public void applyProtocol(PlayerSession playerSession, boolean clearExistingProtocolHandlers) {
        this.applyProtocol(playerSession);
    }

    @Override
    public void applyProtocol(PlayerSession playerSession) {
        LOG.trace("Going to apply {} on session: {}", (Object)this.getProtocolName(), (Object)playerSession);
        ChannelPipeline pipeline = NettyUtils.getPipeLineOfConnection(playerSession);
        pipeline.addLast("textWebsocketDecoder", (ChannelHandler)this.textWebsocketDecoder);
        pipeline.addLast("eventHandler", (ChannelHandler)new DefaultToServerHandler(playerSession));
        pipeline.addLast("textWebsocketEncoder", (ChannelHandler)this.textWebsocketEncoder);
        pipeline.remove("loginHandler");
        pipeline.remove("idleStateCheck");
    }

    public TextWebsocketEncoder getTextWebsocketEncoder() {
        return this.textWebsocketEncoder;
    }

    public void setTextWebsocketEncoder(TextWebsocketEncoder textWebsocketEncoder) {
        this.textWebsocketEncoder = textWebsocketEncoder;
    }

    public TextWebsocketDecoder getTextWebsocketDecoder() {
        return this.textWebsocketDecoder;
    }

    public void setTextWebsocketDecoder(TextWebsocketDecoder textWebsocketDecoder) {
        this.textWebsocketDecoder = textWebsocketDecoder;
    }
}

