/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.nadron.server.netty.NettyConfig;
import io.nadron.server.netty.NettyServer;
import io.nadron.service.GameAdminService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNettyServer
implements NettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNettyServer.class);
    public static final ChannelGroup ALL_CHANNELS = new DefaultChannelGroup("NADRON-CHANNELS", (EventExecutor)GlobalEventExecutor.INSTANCE);
    protected GameAdminService gameAdminService;
    protected final NettyConfig nettyConfig;
    protected ChannelInitializer<? extends Channel> channelInitializer;

    public AbstractNettyServer(NettyConfig nettyConfig, ChannelInitializer<? extends Channel> channelInitializer) {
        this.nettyConfig = nettyConfig;
        this.channelInitializer = channelInitializer;
    }

    @Override
    public void startServer(int port) throws Exception {
        this.nettyConfig.setPortNumber(port);
        this.nettyConfig.setSocketAddress(new InetSocketAddress(port));
        this.startServer();
    }

    @Override
    public void startServer(InetSocketAddress socketAddress) throws Exception {
        this.nettyConfig.setSocketAddress(socketAddress);
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopServer() throws Exception {
        LOG.debug("In stopServer method of class: {}", (Object)this.getClass().getName());
        ChannelGroupFuture future = ALL_CHANNELS.close();
        try {
            future.await();
        }
        catch (InterruptedException e) {
            LOG.error("Execption occurred while waiting for channels to close: {}", (Throwable)e);
        }
        finally {
            if (null != this.nettyConfig.getBossGroup()) {
                this.nettyConfig.getBossGroup().shutdownGracefully();
            }
            if (null != this.nettyConfig.getWorkerGroup()) {
                this.nettyConfig.getWorkerGroup().shutdownGracefully();
            }
            this.gameAdminService.shutdown();
        }
    }

    @Override
    public ChannelInitializer<? extends Channel> getChannelInitializer() {
        return this.channelInitializer;
    }

    @Override
    public NettyConfig getNettyConfig() {
        return this.nettyConfig;
    }

    protected EventLoopGroup getBossGroup() {
        return this.nettyConfig.getBossGroup();
    }

    protected EventLoopGroup getWorkerGroup() {
        return this.nettyConfig.getWorkerGroup();
    }

    public GameAdminService getGameAdminService() {
        return this.gameAdminService;
    }

    public void setGameAdminService(GameAdminService gameAdminService) {
        this.gameAdminService = gameAdminService;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.nettyConfig.getSocketAddress();
    }

    public String toString() {
        return "NettyServer [socketAddress=" + this.nettyConfig.getSocketAddress() + ", portNumber=" + this.nettyConfig.getPortNumber() + "]";
    }
}

