/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.util.Map;

public class NettyConfig {
    private Map<ChannelOption<?>, Object> channelOptions;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;
    private int bossThreadCount;
    private int workerThreadCount;
    private InetSocketAddress socketAddress;
    private int portNumber = 18090;
    protected ChannelInitializer<? extends Channel> channelInitializer;

    public Map<ChannelOption<?>, Object> getChannelOptions() {
        return this.channelOptions;
    }

    public void setChannelOptions(Map<ChannelOption<?>, Object> channelOptions) {
        this.channelOptions = channelOptions;
    }

    public synchronized NioEventLoopGroup getBossGroup() {
        if (null == this.bossGroup) {
            this.bossGroup = 0 >= this.bossThreadCount ? new NioEventLoopGroup() : new NioEventLoopGroup(this.bossThreadCount);
        }
        return this.bossGroup;
    }

    public void setBossGroup(NioEventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public synchronized NioEventLoopGroup getWorkerGroup() {
        if (null == this.workerGroup) {
            this.workerGroup = 0 >= this.workerThreadCount ? new NioEventLoopGroup() : new NioEventLoopGroup(this.workerThreadCount);
        }
        return this.workerGroup;
    }

    public void setWorkerGroup(NioEventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public int getBossThreadCount() {
        return this.bossThreadCount;
    }

    public void setBossThreadCount(int bossThreadCount) {
        this.bossThreadCount = bossThreadCount;
    }

    public int getWorkerThreadCount() {
        return this.workerThreadCount;
    }

    public void setWorkerThreadCount(int workerThreadCount) {
        this.workerThreadCount = workerThreadCount;
    }

    public synchronized InetSocketAddress getSocketAddress() {
        if (null == this.socketAddress) {
            this.socketAddress = new InetSocketAddress(this.portNumber);
        }
        return this.socketAddress;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }
}

