/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.nadron.server.Server;
import io.nadron.server.netty.AbstractNettyServer;
import io.nadron.server.netty.NettyConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTCPServer
extends AbstractNettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTCPServer.class);
    private ServerBootstrap serverBootstrap;

    public NettyTCPServer(NettyConfig nettyConfig, ChannelInitializer<? extends Channel> channelInitializer) {
        super(nettyConfig, channelInitializer);
    }

    @Override
    public void startServer() throws Exception {
        try {
            this.serverBootstrap = new ServerBootstrap();
            Map<ChannelOption<?>, Object> channelOptions = this.nettyConfig.getChannelOptions();
            if (null != channelOptions) {
                Set<ChannelOption<?>> keySet = channelOptions.keySet();
                for (ChannelOption<?> option : keySet) {
                    this.serverBootstrap.option(option, channelOptions.get(option));
                }
            }
            ((ServerBootstrap)this.serverBootstrap.group(this.getBossGroup(), this.getWorkerGroup()).channel(NioServerSocketChannel.class)).childHandler(this.getChannelInitializer());
            Channel serverChannel = this.serverBootstrap.bind((SocketAddress)this.nettyConfig.getSocketAddress()).sync().channel();
            ALL_CHANNELS.add((Object)serverChannel);
        }
        catch (Exception e) {
            LOG.error("TCP Server start error {}, going to shut down", (Throwable)e);
            super.stopServer();
            throw e;
        }
    }

    @Override
    public Server.TransmissionProtocol getTransmissionProtocol() {
        return Server.TRANSMISSION_PROTOCOL.TCP;
    }

    @Override
    public void setChannelInitializer(ChannelInitializer<? extends Channel> initializer) {
        this.channelInitializer = initializer;
        this.serverBootstrap.childHandler(initializer);
    }

    @Override
    public String toString() {
        return "NettyTCPServer [socketAddress=" + this.nettyConfig.getSocketAddress() + ", portNumber=" + this.nettyConfig.getPortNumber() + "]";
    }
}

