/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.nadron.server.Server;
import io.nadron.server.netty.AbstractNettyServer;
import io.nadron.server.netty.NettyConfig;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUDPServer
extends AbstractNettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUDPServer.class);
    private Bootstrap bootstrap;

    public NettyUDPServer(NettyConfig nettyConfig, ChannelInitializer<? extends Channel> channelInitializer) {
        super(nettyConfig, channelInitializer);
    }

    @Override
    public void startServer() throws Exception {
        try {
            this.bootstrap = new Bootstrap();
            Map<ChannelOption<?>, Object> channelOptions = this.nettyConfig.getChannelOptions();
            if (null != channelOptions) {
                Set<ChannelOption<?>> keySet = channelOptions.keySet();
                for (ChannelOption<?> option : keySet) {
                    this.bootstrap.option(option, channelOptions.get(option));
                }
            }
            Channel channel = ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.getBossGroup())).channel(NioDatagramChannel.class)).handler(this.getChannelInitializer())).bind((SocketAddress)this.nettyConfig.getSocketAddress()).channel();
            ALL_CHANNELS.add((Object)channel);
        }
        catch (Exception e) {
            LOG.error("UDP Server start error {}, going to shut down", (Throwable)e);
            super.stopServer();
            throw e;
        }
    }

    @Override
    public Server.TransmissionProtocol getTransmissionProtocol() {
        return Server.TRANSMISSION_PROTOCOL.UDP;
    }

    @Override
    public String toString() {
        return "NettyUDPServer [socketAddress=" + this.nettyConfig.getSocketAddress() + ", portNumber=" + this.nettyConfig.getPortNumber() + "]";
    }

    @Override
    public void setChannelInitializer(ChannelInitializer<? extends Channel> initializer) {
        this.channelInitializer = initializer;
        this.bootstrap.handler(initializer);
    }
}

