/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.nadron.handlers.netty.LoginProtocol;
import io.nadron.handlers.netty.ProtocolMultiplexerDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;

public class ProtocolMultiplexerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int MAX_IDLE_SECONDS = 60;
    private int bytesForProtocolCheck;
    private LoginProtocol loginProtocol;

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("idleStateCheck", (ChannelHandler)new IdleStateHandler(60, 60, 60));
        pipeline.addLast("multiplexer", this.createProtcolMultiplexerDecoder());
    }

    protected ChannelHandler createProtcolMultiplexerDecoder() {
        return new ProtocolMultiplexerDecoder(this.bytesForProtocolCheck, this.loginProtocol);
    }

    public int getBytesForProtocolCheck() {
        return this.bytesForProtocolCheck;
    }

    public void setBytesForProtocolCheck(int bytesForProtocolCheck) {
        this.bytesForProtocolCheck = bytesForProtocolCheck;
    }

    public LoginProtocol getLoginProtocol() {
        return this.loginProtocol;
    }

    public void setLoginProtocol(LoginProtocol loginProtocol) {
        this.loginProtocol = loginProtocol;
    }
}

