/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.server.netty;

import io.nadron.context.AppContext;
import io.nadron.server.ServerManager;
import io.nadron.server.netty.AbstractNettyServer;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManagerImpl
implements ServerManager {
    private Set<AbstractNettyServer> servers = new HashSet<AbstractNettyServer>();
    private static final Logger LOG = LoggerFactory.getLogger(ServerManagerImpl.class);

    @Override
    public void startServers(int tcpPort, int flashPort, int udpPort) throws Exception {
        if (tcpPort > 0) {
            AbstractNettyServer tcpServer = (AbstractNettyServer)AppContext.getBean("tcpServer");
            tcpServer.startServer(tcpPort);
            this.servers.add(tcpServer);
        }
        if (flashPort > 0) {
            AbstractNettyServer flashServer = (AbstractNettyServer)AppContext.getBean("flashPolicyServer");
            flashServer.startServer(flashPort);
            this.servers.add(flashServer);
        }
        if (udpPort > 0) {
            AbstractNettyServer udpServer = (AbstractNettyServer)AppContext.getBean("udpServer");
            udpServer.startServer(udpPort);
            this.servers.add(udpServer);
        }
    }

    @Override
    public void startServers() throws Exception {
        AbstractNettyServer tcpServer = (AbstractNettyServer)AppContext.getBean("tcpServer");
        tcpServer.startServer();
        this.servers.add(tcpServer);
        AbstractNettyServer flashServer = (AbstractNettyServer)AppContext.getBean("flashPolicyServer");
        flashServer.startServer();
        this.servers.add(flashServer);
        AbstractNettyServer udpServer = (AbstractNettyServer)AppContext.getBean("udpServer");
        udpServer.startServer();
        this.servers.add(udpServer);
    }

    @Override
    public void stopServers() throws Exception {
        for (AbstractNettyServer nettyServer : this.servers) {
            try {
                nettyServer.stopServer();
            }
            catch (Exception e) {
                LOG.error("Unable to stop server {} due to error {}", (Object)nettyServer, (Object)e);
                throw e;
            }
        }
    }
}

