/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.service.impl;

import io.nadron.app.Session;
import io.nadron.app.Task;
import io.nadron.service.TaskManagerService;
import io.nadron.service.impl.SessionRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReconnectSessionRegistry
extends SessionRegistry<String> {
    TaskManagerService taskManagerService;
    int reconnectDelay = 300000;

    @Override
    public boolean putSession(String key, Session session) {
        this.taskManagerService.schedule(new ClearSessionTask(key, this.sessions), this.reconnectDelay, TimeUnit.MILLISECONDS);
        return super.putSession(key, session);
    }

    public TaskManagerService getTaskManagerService() {
        return this.taskManagerService;
    }

    public void setTaskManagerService(TaskManagerService taskManagerService) {
        this.taskManagerService = taskManagerService;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    protected static class ClearSessionTask
    implements Task {
        final String reconnectKey;
        final Map<String, Session> sessions;

        protected ClearSessionTask(String reconnectKey, Map<String, Session> sessions) {
            this.reconnectKey = reconnectKey;
            this.sessions = sessions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = this.sessions.get(this.reconnectKey);
            if (null != session) {
                Session session2 = session;
                synchronized (session2) {
                    Session removeSession = this.sessions.remove(this.reconnectKey);
                    if (null != removeSession) {
                        removeSession.close();
                    }
                }
            }
        }

        @Override
        public Object getId() {
            return null;
        }

        @Override
        public void setId(Object id) {
        }
    }
}

