/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.util;

import io.nadron.app.PlayerSession;
import io.nadron.communication.NettyTCPMessageSender;
import io.nadron.convert.Transform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    public static final String NETTY_CHANNEL = "NETTY_CHANNEL";

    public static ChannelPipeline getPipeLineOfConnection(NettyTCPMessageSender messageSender) {
        if (null != messageSender) {
            Channel channel = messageSender.getChannel();
            ChannelPipeline pipeline = channel.pipeline();
            return pipeline;
        }
        return null;
    }

    public static ChannelPipeline getPipeLineOfConnection(PlayerSession playerSession) {
        return NettyUtils.getPipeLineOfConnection((NettyTCPMessageSender)playerSession.getTcpSender());
    }

    public static void clearPipeline(ChannelPipeline pipeline) {
        if (null == pipeline) {
            return;
        }
        try {
            int counter = 0;
            while (pipeline.first() != null) {
                pipeline.removeFirst();
                ++counter;
            }
            LOG.trace("Removed {} handlers from pipeline", (Object)counter);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static ByteBuf createBufferForOpcode(int opcode) {
        ByteBuf buffer = Unpooled.buffer((int)1);
        buffer.writeByte(opcode);
        return buffer;
    }

    public static String[] readStrings(ByteBuf buffer, int numOfStrings) {
        return NettyUtils.readStrings(buffer, numOfStrings, CharsetUtil.UTF_8);
    }

    public static String[] readStrings(ByteBuf buffer, int numOfStrings, Charset charset) {
        String theStr;
        String[] strings = new String[numOfStrings];
        for (int i = 0; i < numOfStrings && null != (theStr = NettyUtils.readString(buffer, charset)); ++i) {
            strings[i] = theStr;
        }
        return strings;
    }

    public static String readString(ByteBuf buffer) {
        return NettyUtils.readString(buffer, CharsetUtil.UTF_8);
    }

    public static String readString(ByteBuf buffer, Charset charset) {
        String readString = null;
        if (null != buffer && buffer.readableBytes() > 2) {
            int length = buffer.readUnsignedShort();
            readString = NettyUtils.readString(buffer, length, charset);
        }
        return readString;
    }

    public static String readString(ByteBuf buffer, int length) {
        return NettyUtils.readString(buffer, length, CharsetUtil.UTF_8);
    }

    public static String readString(ByteBuf buffer, int length, Charset charset) {
        String str = null;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            ByteBuf stringBuffer = buffer.readSlice(length);
            str = stringBuffer.toString(charset);
        }
        catch (Exception e) {
            LOG.error("Error occurred while trying to read string from buffer: {}", (Throwable)e);
        }
        return str;
    }

    public static ByteBuf writeStrings(String ... msgs) {
        return NettyUtils.writeStrings(CharsetUtil.UTF_8, msgs);
    }

    public static ByteBuf writeStrings(Charset charset, String ... msgs) {
        ByteBuf buffer = null;
        for (String msg : msgs) {
            if (null == buffer) {
                buffer = NettyUtils.writeString(msg, charset);
                continue;
            }
            ByteBuf theBuffer = NettyUtils.writeString(msg, charset);
            if (null == theBuffer) continue;
            buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, theBuffer});
        }
        return buffer;
    }

    public static ByteBuf writeString(String msg) {
        return NettyUtils.writeString(msg, CharsetUtil.UTF_8);
    }

    public static ByteBuf writeString(String msg, Charset charset) {
        ByteBuf buffer = null;
        try {
            ByteBuf stringBuffer = null;
            if (null == charset) {
                charset = CharsetUtil.UTF_8;
            }
            stringBuffer = Unpooled.copiedBuffer((CharSequence)msg, (Charset)charset);
            int length = stringBuffer.readableBytes();
            ByteBuf lengthBuffer = Unpooled.buffer((int)2);
            lengthBuffer.writeShort(length);
            buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{lengthBuffer, stringBuffer});
        }
        catch (Exception e) {
            LOG.error("Error occurred while trying to write string buffer: {}", (Throwable)e);
        }
        return buffer;
    }

    public static <T, V> V readObject(ByteBuf buffer, Transform<ByteBuf, V> decoder) {
        int length = 0;
        if (null == buffer || buffer.readableBytes() <= 2) {
            return null;
        }
        length = buffer.readUnsignedShort();
        ByteBuf objBuffer = buffer.readSlice(length);
        V obj = null;
        try {
            obj = decoder.convert(objBuffer);
        }
        catch (Exception e) {
            LOG.error("Error occurred while trying to read object from buffer: {}", (Throwable)e);
        }
        return obj;
    }

    public static <V> ByteBuf writeObject(Transform<V, ByteBuf> converter, V object) {
        ByteBuf buffer = null;
        try {
            ByteBuf objectBuffer = converter.convert(object);
            int length = objectBuffer.readableBytes();
            ByteBuf lengthBuffer = Unpooled.buffer((int)2);
            lengthBuffer.writeShort(length);
            buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{lengthBuffer, objectBuffer});
        }
        catch (Exception e) {
            LOG.error("Error occurred while writing object to buffer: {}", (Throwable)e);
        }
        return buffer;
    }

    public static InetSocketAddress readSocketAddress(ByteBuf buffer) {
        String remoteHost = NettyUtils.readString(buffer);
        int remotePort = 0;
        if (buffer.readableBytes() < 4) {
            return null;
        }
        remotePort = buffer.readInt();
        InetSocketAddress remoteAddress = null;
        if (null != remoteHost) {
            remoteAddress = new InetSocketAddress(remoteHost, remotePort);
        }
        return remoteAddress;
    }

    public static ByteBuf writeSocketAddress(InetSocketAddress socketAddress) {
        String host = socketAddress.getHostName();
        int port = socketAddress.getPort();
        ByteBuf hostName = NettyUtils.writeString(host);
        ByteBuf portNum = Unpooled.buffer((int)4);
        portNum.writeInt(port);
        ByteBuf socketAddressBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{hostName, portNum});
        return socketAddressBuffer;
    }
}

