/*
 * Decompiled with CFR 0.152.
 */
package com.github.menglim.dbutils;

import com.github.menglim.dbutils.DbFactoryHelper;

public class Condition {

    public static class Builder<T> {
        private String conditional = "";
        private T newInstance;
        private DbFactoryHelper<T> factoryHelper;

        public Builder(T newInstance) {
            this.newInstance = newInstance;
            this.factoryHelper = new DbFactoryHelper();
        }

        public Builder where(String objectFieldName) {
            String fieldName = this.factoryHelper.getFieldName(this.newInstance, objectFieldName);
            this.conditional = " WHERE " + fieldName + "=:" + fieldName;
            return this;
        }

        public Builder and(String objectFieldName) {
            String fieldName = this.factoryHelper.getFieldName(this.newInstance, objectFieldName);
            this.conditional = this.conditional + " AND " + fieldName + "=:" + fieldName;
            return this;
        }

        public Builder or(String objectFieldName) {
            String fieldName = this.factoryHelper.getFieldName(this.newInstance, objectFieldName);
            this.conditional = this.conditional + " OR " + fieldName + "=:" + fieldName;
            return this;
        }

        public Builder andLike(String objectFieldName) {
            String fieldName = this.factoryHelper.getFieldName(this.newInstance, objectFieldName);
            this.conditional = this.conditional + " AND LIKE " + fieldName + "=%:" + fieldName + "%";
            return this;
        }

        public Builder orderBy(String objectFieldName) {
            String fieldName = this.factoryHelper.getFieldName(this.newInstance, objectFieldName);
            this.conditional = " ORDER BY " + fieldName;
            return this;
        }

        public String build() {
            return this.conditional;
        }

        public T getInstance() {
            return this.newInstance;
        }
    }
}

