/*
 * Decompiled with CFR 0.152.
 */
package com.github.menglim.dbutils;

import com.github.menglim.dbutils.Condition;
import com.github.menglim.dbutils.DbConnectionManager;
import com.github.menglim.dbutils.DbException;
import com.github.menglim.dbutils.DbFactoryHelper;
import com.github.menglim.dbutils.NamedParameterStatement;
import com.github.menglim.dbutils.OrderBy;
import com.github.menglim.dbutils.interfaces.BaseObjectModel;
import com.github.menglim.dbutils.interfaces.Factory;
import com.github.menglim.mutils.AppUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbFactory<T>
implements Factory<T> {
    private static final Logger log = LoggerFactory.getLogger(DbFactory.class);
    private BaseObjectModel<T> baseObjectModel;
    private DbFactoryHelper<T> _factoryHelper = new DbFactoryHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> selectMany(T newInstance, Condition.Builder conditionBuilder, OrderBy.Builder orderBuilder) {
        ArrayList<T> list;
        block31: {
            list = new ArrayList<T>();
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block31;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            String tableName = this._factoryHelper.getTableName(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                String sql = "SELECT * FROM " + tableName;
                if (conditionBuilder != null) {
                    sql = sql + conditionBuilder.build();
                }
                if (orderBuilder != null) {
                    sql = sql + orderBuilder.build();
                }
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                if (conditionBuilder != null) {
                    this._factoryHelper.setParameters(statement, conditionBuilder.getInstance());
                }
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                while (rs.next()) {
                    newInstance = this._factoryHelper.setField(newInstance, rs);
                    list.add(newInstance);
                    newInstance = this.baseObjectModel.newInstance();
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> selectMany(String sql, T newInstance, Condition.Builder conditionBuilder, OrderBy.Builder orderBuilder) {
        ArrayList<T> list;
        block31: {
            list = new ArrayList<T>();
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block31;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                if (conditionBuilder != null) {
                    sql = sql + conditionBuilder.build();
                }
                if (orderBuilder != null) {
                    sql = sql + orderBuilder.build();
                }
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                if (conditionBuilder != null) {
                    this._factoryHelper.setParameters(statement, conditionBuilder.getInstance());
                }
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                while (rs.next()) {
                    list.add(this._factoryHelper.setField(newInstance, rs));
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> selectMany(T newInstance, Function<ResultSet, T> function, Condition.Builder conditionBuilder, OrderBy.Builder orderBuilder) {
        ArrayList<T> list;
        block31: {
            list = new ArrayList<T>();
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block31;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            String tableName = this._factoryHelper.getTableName(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                String sql = "SELECT * FROM " + tableName;
                if (conditionBuilder != null) {
                    sql = sql + conditionBuilder.build();
                }
                if (orderBuilder != null) {
                    sql = sql + orderBuilder.build();
                }
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                if (conditionBuilder != null) {
                    this._factoryHelper.setParameters(statement, conditionBuilder.getInstance());
                }
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                while (rs.next()) {
                    list.add(function.apply(rs));
                }
                rs.close();
                statement.close();
                connection.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T selectOne(String sql, T newInstance, Function<ResultSet, T> function) {
        block19: {
            if (function == null) {
                try {
                    throw new Exception("Function cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block19;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = function.apply(rs);
                }
                rs.close();
                statement.close();
                connection.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T selectOne(String sql, T newInstance) {
        block16: {
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block16;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = this._factoryHelper.setField(newInstance, rs);
                }
                rs.close();
                statement.close();
                connection.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T selectOne(T newInstance, Function<ResultSet, T> function, Condition.Builder conditionBuilder, OrderBy.Builder orderBuilder) {
        block20: {
            if (function == null) {
                try {
                    throw new Exception("Function cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block20;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                NamedParameterStatement statement;
                ResultSet rs;
                String sql = "SELECT * FROM " + this._factoryHelper.getTableName(newInstance);
                log.info("Executing Sql => " + sql);
                if (orderBuilder != null) {
                    sql = sql + orderBuilder.build();
                }
                ResultSet resultSet = rs = (statement = new NamedParameterStatement(connection, sql)) != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = function.apply(rs);
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    @Override
    public T selectOne(T newInstance, Function<ResultSet, T> function, Condition.Builder conditionBuilder) {
        return this.selectOne(newInstance, function, conditionBuilder, null);
    }

    @Override
    public T selectOne(T newInstance, Function<ResultSet, T> function) {
        return this.selectOne(newInstance, function, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T selectOne(T newInstance, Condition.Builder conditionBuilder, OrderBy.Builder orderBuilder) {
        block17: {
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block17;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                String sql = "SELECT * FROM " + this._factoryHelper.getTableName(newInstance);
                if (orderBuilder != null) {
                    sql = sql + orderBuilder.build();
                }
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = this._factoryHelper.setField(newInstance, rs);
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    @Override
    public T selectOne(T newInstance, Condition.Builder conditionBuilder) {
        return this.selectOne(newInstance, conditionBuilder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key> T selectOne(T newInstance, Key idValue) {
        block29: {
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block29;
                }
            }
            Field primaryKeyField = this._factoryHelper.getPrimaryKeyField(newInstance);
            if (primaryKeyField == null) {
                throw new DbException("PrimaryKey not found");
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                String primaryKeyValue = BeanUtils.getProperty(newInstance, (String)primaryKeyField.getName());
                String sql = "SELECT * FROM " + this._factoryHelper.getTableName(newInstance) + " WHERE " + this._factoryHelper.getFieldName(newInstance, primaryKeyField.getName()) + "=" + primaryKeyValue;
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = this._factoryHelper.setField(newInstance, rs);
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key> T selectOne(T newInstance, Function<ResultSet, T> function, Key idValue) {
        block32: {
            if (function == null) {
                try {
                    throw new Exception("Function cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block32;
                }
            }
            Field primaryKeyField = this._factoryHelper.getPrimaryKeyField(newInstance);
            if (primaryKeyField == null) {
                throw new DbException("PrimaryKey not found");
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                String primaryKeyValue = BeanUtils.getProperty(newInstance, (String)primaryKeyField.getName());
                String sql = "SELECT * FROM " + this._factoryHelper.getTableName(newInstance) + " WHERE " + this._factoryHelper.getFieldName(newInstance, primaryKeyField.getName()) + "=" + primaryKeyValue;
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                if (rs.next()) {
                    newInstance = function.apply(rs);
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> selectMany(String sql, T newInstance, Function<ResultSet, T> function, Condition.Builder conditionBuilder) {
        ArrayList<T> list;
        block32: {
            list = new ArrayList<T>();
            if (function == null) {
                try {
                    throw new Exception("Function cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (newInstance == null) {
                try {
                    throw new Exception("newInstance cannot be null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block32;
                }
            }
            this.baseObjectModel = (BaseObjectModel)newInstance;
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Connection connection = DbConnectionManager.getConnection(connectionIndex);
            try {
                ResultSet rs;
                log.info("Executing Sql => " + sql);
                NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
                if (conditionBuilder != null) {
                    this._factoryHelper.setParameters(statement, conditionBuilder.getInstance());
                }
                ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
                while (rs.next()) {
                    list.add(function.apply(rs));
                }
                rs.close();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        log.info("Connection is closed");
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<T> selectMany(String sql, T newInstance, Condition.Builder conditionBuilder) throws Exception {
        ResultSet rs;
        ArrayList<T> list = new ArrayList<T>();
        if (newInstance == null) {
            throw new Exception("newInstance cannot be null");
        }
        this.baseObjectModel = (BaseObjectModel)newInstance;
        int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
        Connection connection = DbConnectionManager.getConnection(connectionIndex);
        log.info("Executing Sql => " + sql);
        NamedParameterStatement statement = new NamedParameterStatement(connection, sql);
        if (conditionBuilder != null) {
            this._factoryHelper.setParameters(statement, conditionBuilder.getInstance());
        }
        ResultSet resultSet = rs = statement != null ? statement.executeQuery() : null;
        while (rs.next()) {
            if ((newInstance = this._factoryHelper.setField(newInstance, rs)) != null) {
                list.add(newInstance);
            }
            newInstance = this.baseObjectModel.newInstance();
        }
        rs.close();
        statement.close();
        connection.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T save(T newInstance) {
        block28: {
            Connection connection = null;
            NamedParameterStatement preparedStmt = null;
            try {
                int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
                Field primaryKeyField = this._factoryHelper.getPrimaryKeyField(newInstance);
                if (primaryKeyField == null) {
                    throw new SQLException("PrimaryKey not found");
                }
                String primaryKeyValue = BeanUtils.getProperty(newInstance, (String)primaryKeyField.getName());
                String sql = "";
                if (AppUtils.getInstance().isNull((Object)primaryKeyValue)) {
                    sql = this._factoryHelper.getInsertSql(newInstance);
                    log.info("Executing Sql => " + sql);
                    connection = DbConnectionManager.getConnection(connectionIndex);
                    preparedStmt = new NamedParameterStatement(Objects.requireNonNull(connection), sql, 1);
                    preparedStmt = this._factoryHelper.setParameters(preparedStmt, newInstance);
                    preparedStmt.executeUpdate();
                    ResultSet rs = preparedStmt.getGenerateKey();
                    Long lastInsertKey = 0L;
                    if (rs.next()) {
                        lastInsertKey = rs.getLong(1);
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    BeanUtils.setProperty(newInstance, (String)primaryKeyField.getName(), (Object)lastInsertKey);
                    break block28;
                }
                sql = this._factoryHelper.getUpdateSql(newInstance);
                log.info("Executing Sql => " + sql);
                connection = DbConnectionManager.getConnection(connectionIndex);
                preparedStmt = new NamedParameterStatement(Objects.requireNonNull(connection), sql);
                preparedStmt = this._factoryHelper.setParameters(preparedStmt, newInstance);
                preparedStmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    preparedStmt.close();
                    connection.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(T newInstance) {
        Connection connection = null;
        NamedParameterStatement preparedStmt = null;
        try {
            int connectionIndex = this._factoryHelper.getConnectionIndex(newInstance);
            Field primaryKeyField = this._factoryHelper.getPrimaryKeyField(newInstance);
            if (primaryKeyField == null) {
                throw new SQLException("PrimaryKey not found");
            }
            String primaryKeyValue = BeanUtils.getProperty(newInstance, (String)primaryKeyField.getName());
            String sql = this._factoryHelper.getUpdateSql(newInstance);
            log.info("Executing Sql => " + sql);
            connection = DbConnectionManager.getConnection(connectionIndex);
            preparedStmt = new NamedParameterStatement(Objects.requireNonNull(connection), sql);
            preparedStmt = this._factoryHelper.setParameters(preparedStmt, newInstance);
            preparedStmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        finally {
            try {
                preparedStmt.close();
                connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return newInstance;
    }

    @Override
    public List<T> selectMany(T newInstance, Function<ResultSet, T> function) {
        return this.selectMany(newInstance, function, null, null);
    }
}

