/*
 * Decompiled with CFR 0.152.
 */
package com.github.menglim.dbutils;

import com.github.menglim.dbutils.DbConnectionManager;
import com.github.menglim.dbutils.DbException;
import com.github.menglim.dbutils.NamedParameterStatement;
import com.github.menglim.dbutils.annotations.DbDataSource;
import com.github.menglim.dbutils.annotations.DbDateFormat;
import com.github.menglim.dbutils.annotations.DbField;
import com.github.menglim.mutils.AppUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbFactoryHelper<T> {
    private static final Logger log = LoggerFactory.getLogger(DbFactoryHelper.class);

    String getTableName(T newInstance) {
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        String tableName = newInstance.getClass().getSimpleName();
        DbDataSource annotation = newInstance.getClass().getAnnotation(DbDataSource.class);
        if (annotation != null) {
            DbDataSource odbcTableName = annotation;
            tableName = odbcTableName.schema();
        }
        return tableName;
    }

    int getConnectionIndex(T newInstance) {
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        DbDataSource annotation = newInstance.getClass().getAnnotation(DbDataSource.class);
        if (annotation != null) {
            DbDataSource odbcTableName = annotation;
            return odbcTableName.connectionIndex();
        }
        return 0;
    }

    T setField(T newInstance, ResultSet rs) {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        if (rs == null) {
            throw new DbException("ResultSet cannot be NULL");
        }
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            String defaultFieldValue = null;
            DbField fieldAnnotation = field.getAnnotation(DbField.class);
            DbField odbcField = null;
            if (fieldAnnotation != null) {
                odbcField = fieldAnnotation;
                if (odbcField.ignore()) continue;
                fieldName = odbcField.value();
                defaultFieldValue = odbcField.defaultValueIfNull().equalsIgnoreCase("") ? null : odbcField.defaultValueIfNull();
            }
            DbDateFormat dateFormatAnnotation = field.getAnnotation(DbDateFormat.class);
            try {
                Object value;
                if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE) || field.getType().equals(Short.TYPE)) {
                    value = rs.getInt(fieldName);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                    continue;
                }
                if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                    value = rs.getDouble(fieldName);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                    continue;
                }
                if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                    value = rs.getLong(fieldName);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    value = rs.getString(fieldName);
                    if (AppUtils.getInstance().nonNull(value)) {
                        if (dateFormatAnnotation != null) {
                            Object dbDateFormat = dateFormatAnnotation;
                            switch (dbDateFormat.fromFormatDate()) {
                                case YYYYMMDD: 
                                case MMDDYYYY: 
                                case DDMMYYYY: {
                                    value = ((String)value).substring(0, 8 + (dbDateFormat.fromDateSeparator().length() + dbDateFormat.fromDateSeparator().length()));
                                    break;
                                }
                                default: {
                                    value = AppUtils.getInstance().toDate((String)value, dbDateFormat.fromFormatDate(), dbDateFormat.toFormatDate());
                                }
                            }
                        }
                        BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                        continue;
                    }
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)defaultFieldValue);
                    continue;
                }
                if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                    value = rs.getString(fieldName);
                    if (Objects.isNull(value)) {
                        BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)false);
                        break;
                    }
                    switch (Strings.toUpperCase((String)value).trim()) {
                        case "Y": 
                        case "YES": 
                        case "TRUE": 
                        case "SUCCESS": 
                        case "ACTIVE": 
                        case "1": {
                            BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)true);
                            break;
                        }
                        default: {
                            BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)false);
                            break;
                        }
                    }
                    continue;
                }
                if (field.getType().equals(Date.class)) {
                    String formatter = DbConnectionManager.getDateFormat(this.getConnectionIndex(newInstance));
                    if (odbcField != null && AppUtils.getInstance().nonNull((Object)odbcField.formatter())) {
                        formatter = odbcField.formatter();
                    }
                    Date value2 = AppUtils.getInstance().getDate(rs.getString(fieldName), formatter);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value2);
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    value = rs.getBigDecimal(fieldName);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                    continue;
                }
                if (field.getType().equals(byte[].class)) {
                    value = rs.getBytes(fieldName);
                    BeanUtils.setProperty(newInstance, (String)field.getName(), (Object)value);
                    continue;
                }
                log.error("Unknown datatype " + field.getType());
            }
            catch (IllegalAccessException | InvocationTargetException | SQLException e) {
                log.error("Field name => " + fieldName);
                e.printStackTrace();
            }
        }
        return newInstance;
    }

    String getInsertSql(T newInstance) {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        String sql = "INSERT INTO " + this.getTableName(newInstance) + "(";
        String insertFields = "";
        String insertValues = "";
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            DbField odbcField;
            String fieldName = field.getName();
            DbField fieldAnn = field.getAnnotation(DbField.class);
            if (fieldAnn == null || (odbcField = fieldAnn).ignore() || !odbcField.insertField() || odbcField.primaryKey()) continue;
            fieldName = AppUtils.getInstance().isNull((Object)odbcField.value()) ? field.getName() : odbcField.value();
            insertFields = insertFields + fieldName + ",";
            insertValues = insertValues + ":" + fieldName + ",";
        }
        insertFields = insertFields.substring(0, insertFields.length() - 1);
        insertValues = insertValues.substring(0, insertValues.length() - 1);
        sql = sql + insertFields + ") VALUES (" + insertValues + ")";
        log.info("INSERT STATEMENT => " + sql);
        return sql;
    }

    String getUpdateSql(T newInstance) {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        String sql = "UPDATE " + this.getTableName(newInstance) + " SET ";
        String updateField = "";
        String where = " WHERE ";
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            DbField fieldAnn = field.getAnnotation(DbField.class);
            if (fieldAnn == null) continue;
            DbField odbcField = fieldAnn;
            if (odbcField.updateField() && !odbcField.primaryKey()) {
                fieldName = AppUtils.getInstance().isNull((Object)odbcField.value()) ? field.getName() : odbcField.value();
                updateField = updateField + fieldName + "=:" + fieldName + ",";
            }
            if (!odbcField.primaryKey()) continue;
            fieldName = AppUtils.getInstance().isNull((Object)odbcField.value()) ? field.getName() : odbcField.value();
            where = where + fieldName + "=:" + fieldName;
        }
        updateField = updateField.substring(0, updateField.length() - 1);
        sql = sql + updateField + where;
        log.info("UPDATE STATEMENT => " + sql);
        return sql;
    }

    Field getPrimaryKeyField(T newInstance) {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            DbField odbcField;
            DbField fieldAnn = field.getAnnotation(DbField.class);
            if (fieldAnn == null || (odbcField = fieldAnn).ignore() || !odbcField.primaryKey()) continue;
            return field;
        }
        return null;
    }

    private String getSelectSql(T newInstance) {
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        return null;
    }

    NamedParameterStatement setParameters(NamedParameterStatement preparedStmt, T newInstance) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, SQLException {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        if (preparedStmt == null) {
            throw new DbException("PreparedStmt cannot be NULL");
        }
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            DbField odbcField;
            String fieldName = field.getName();
            DbField fieldAnn = field.getAnnotation(DbField.class);
            if (fieldAnn == null || !(odbcField = fieldAnn).insertField() && !odbcField.updateField()) continue;
            String string = fieldName = AppUtils.getInstance().isNull((Object)odbcField.value()) ? field.getName() : odbcField.value();
            if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE) || field.getType().equals(Short.TYPE)) {
                if (!AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) continue;
                preparedStmt.setInt("" + fieldName, Integer.parseInt(BeanUtils.getProperty(newInstance, (String)field.getName())));
                continue;
            }
            if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                if (!AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) continue;
                preparedStmt.setDouble("" + fieldName, Double.valueOf(BeanUtils.getProperty(newInstance, (String)field.getName())));
                continue;
            }
            if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                if (!AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) continue;
                preparedStmt.setLong("" + fieldName, Long.parseLong(BeanUtils.getProperty(newInstance, (String)field.getName())));
                continue;
            }
            if (field.getType().equals(String.class)) {
                if (AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) {
                    preparedStmt.setString("" + fieldName, BeanUtils.getProperty(newInstance, (String)field.getName()));
                    continue;
                }
                preparedStmt.setString("" + fieldName, null);
                continue;
            }
            if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                if (!AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) continue;
                switch (Strings.toUpperCase((String)BeanUtils.getProperty(newInstance, (String)field.getName())).trim()) {
                    case "Y": 
                    case "YES": 
                    case "TRUE": {
                        preparedStmt.setBoolean("" + fieldName, true);
                        break;
                    }
                    default: {
                        preparedStmt.setBoolean("" + fieldName, false);
                        break;
                    }
                }
                continue;
            }
            if (field.getType().equals(Date.class)) {
                if (!AppUtils.getInstance().nonNull((Object)BeanUtils.getProperty(newInstance, (String)field.getName()))) continue;
                preparedStmt.setTimestamp("" + fieldName, Timestamp.valueOf(BeanUtils.getProperty(newInstance, (String)field.getName())));
                continue;
            }
            log.error("Unknown datatype " + field.getType());
        }
        return preparedStmt;
    }

    String getFieldName(T newInstance, String objectFieldName) {
        Field[] fields;
        if (newInstance == null) {
            throw new DbException("NewInstance cannot be NULL");
        }
        for (Field field : fields = newInstance.getClass().getDeclaredFields()) {
            DbField odbcField;
            DbField fieldAnn = field.getAnnotation(DbField.class);
            if (fieldAnn == null || !field.getName().equalsIgnoreCase(objectFieldName) || (odbcField = fieldAnn).ignore()) continue;
            return AppUtils.getInstance().isNull((Object)odbcField.value()) ? field.getName() : odbcField.value();
        }
        return null;
    }
}

