/*
 * Decompiled with CFR 0.152.
 */
package com.github.menglim.dbutils;

import com.github.menglim.dbutils.DbFactoryHelper;

public class OrderBy {

    public static enum Direction {
        ASC,
        DESC;

    }

    public static class Builder<T> {
        private String orderBy = "";
        private T newInstance;
        private DbFactoryHelper<T> factoryHelper;

        public Builder(T newInstance) {
            this.newInstance = newInstance;
            this.factoryHelper = new DbFactoryHelper();
        }

        public Builder orderBy(Direction direction, String ... objectFieldNames) {
            String orderFiledNames = "";
            for (String aFieldName : objectFieldNames) {
                String fieldName = this.factoryHelper.getFieldName(this.newInstance, aFieldName);
                orderFiledNames = orderFiledNames + fieldName + ",";
            }
            if (orderFiledNames.endsWith(",")) {
                orderFiledNames = orderFiledNames.substring(orderFiledNames.length() - 1);
            }
            this.orderBy = " ORDER BY " + orderFiledNames + " " + direction.toString();
            return this;
        }

        public String build() {
            return this.orderBy;
        }
    }
}

