/*
 * Decompiled with CFR 0.152.
 */
package com.github.mertakdut;

import com.github.mertakdut.BaseFindings;
import com.github.mertakdut.BookSection;
import com.github.mertakdut.Container;
import com.github.mertakdut.ContextHelper;
import com.github.mertakdut.CssStatus;
import com.github.mertakdut.NavPoint;
import com.github.mertakdut.Optionals;
import com.github.mertakdut.Package;
import com.github.mertakdut.Pair;
import com.github.mertakdut.Tag;
import com.github.mertakdut.Toc;
import com.github.mertakdut.exception.OutOfPagesException;
import com.github.mertakdut.exception.ReadingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.SAXException;

class Content {
    private String zipFilePath;
    private Container container;
    private Package opfPackage;
    private Toc toc;
    private List<String> entryNames = new ArrayList<String>();
    private Map<String, List<Tag>> entryTagPositions;
    private List<String> nonExistingHrefList;
    private int peakPage;
    private BookSection lastBookSectionInfo;

    public Content() {
        this.container = new Container();
        this.opfPackage = new Package();
        this.toc = new Toc();
    }

    void print() {
        System.out.println("Printing zipEntryNames...\n");
        for (int i = 0; i < this.entryNames.size(); ++i) {
            System.out.println("(" + i + ")" + this.entryNames.get(i));
        }
        this.getContainer().print();
        this.getPackage().print();
        this.getToc().print();
    }

    BookSection maintainBookSections(int index) throws ReadingException, OutOfPagesException {
        if (this.peakPage == index) {
            ++this.peakPage;
        } else {
            while (this.peakPage < index) {
                this.getBookSection(this.peakPage++);
            }
        }
        return this.getBookSection(index);
    }

    private BookSection getBookSection(int index) throws ReadingException, OutOfPagesException {
        BookSection bookSection = null;
        NavPoint navPoint = this.getNavPoint(index);
        bookSection = Optionals.maxContentPerSection == 0 || navPoint.getTypeCode() == 0 || navPoint.getTypeCode() == 1 ? this.prepareBookSection(navPoint, index) : this.prepareTrimmedBookSection(navPoint, index);
        this.getToc().setLastPageIndex(index);
        return bookSection;
    }

    private NavPoint getNavPoint(int index) throws ReadingException, OutOfPagesException {
        if (index >= 0) {
            List<NavPoint> navPoints;
            if (this.getToc() != null && (navPoints = this.getToc().getNavMap().getNavPoints()) != null) {
                if (index >= navPoints.size()) {
                    throw new OutOfPagesException(index, navPoints.size());
                }
                return navPoints.get(index);
            }
            throw new ReadingException("Term of Contents is null.");
        }
        throw new ReadingException("Index can't be less than 0");
    }

    private BookSection prepareBookSection(NavPoint navPoint, int index) throws ReadingException, OutOfPagesException {
        BookSection bookSection = new BookSection();
        int trimStartPosition = navPoint.getBodyTrimStartPosition();
        int trimEndPosition = navPoint.getBodyTrimEndPosition();
        String entryName = navPoint.getEntryName();
        String fileContentStr = null;
        String htmlBody = null;
        if (!navPoint.isCalculated()) {
            String href = navPoint.getContentSrc();
            String label = navPoint.getNavLabel();
            boolean isSourceFileFound = false;
            for (int i = 0; i < this.getEntryNames().size(); ++i) {
                int calculatedTrimEndPosition;
                String fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(this.getEntryNames().get(i), '/'));
                if (!href.equals(fileName) && (!href.startsWith(fileName) || !href.replace(fileName, "").startsWith("%23"))) continue;
                isSourceFileFound = true;
                entryName = this.getEntryNames().get(i);
                fileContentStr = this.readFileContent(entryName);
                htmlBody = this.getHtmlBody(fileContentStr);
                if (!href.equals(fileName)) {
                    Pair<Integer, Integer> bodyIntervals = this.getNextAvailableAnchorIndex2(index, entryName, htmlBody, href, fileName);
                    if (bodyIntervals != null) {
                        trimStartPosition = bodyIntervals.getFirst();
                        trimEndPosition = bodyIntervals.getSecond();
                    } else {
                        return this.getBookSection(index);
                    }
                }
                String extension = ContextHelper.getTextAfterCharacter(fileName, '.');
                String mediaType = this.getMediaType(fileName);
                if (Optionals.maxContentPerSection != 0 && (calculatedTrimEndPosition = this.calculateTrimEndPosition(entryName, htmlBody, trimStartPosition, trimEndPosition)) != -1) {
                    trimEndPosition = calculatedTrimEndPosition;
                    NavPoint nextEntryNavPoint = new NavPoint();
                    nextEntryNavPoint.setTypeCode(2);
                    nextEntryNavPoint.setEntryName(entryName);
                    nextEntryNavPoint.setBodyTrimStartPosition(trimEndPosition);
                    this.getToc().getNavMap().getNavPoints().add(index + 1, nextEntryNavPoint);
                    this.getToc().getNavMap().getNavPoints().get(index).setTypeCode(2);
                    if (this.lastBookSectionInfo == null) {
                        this.lastBookSectionInfo = new BookSection();
                    }
                    this.lastBookSectionInfo.setExtension(extension);
                    this.lastBookSectionInfo.setLabel(label);
                    this.lastBookSectionInfo.setMediaType(mediaType);
                }
                bookSection.setExtension(extension);
                bookSection.setLabel(label);
                bookSection.setMediaType(mediaType);
                break;
            }
            if (!isSourceFileFound) {
                System.out.println("Source file not found!");
                this.getToc().getNavMap().getNavPoints().remove(index);
                return this.getBookSection(index);
            }
        } else {
            fileContentStr = this.readFileContent(entryName);
            htmlBody = this.getHtmlBody(fileContentStr);
        }
        if (Optionals.isIncludingTextContent) {
            bookSection.setSectionTextContent(this.getOnlyTextContent(entryName, htmlBody, trimStartPosition, trimEndPosition));
        }
        if (Optionals.cssStatus == CssStatus.OMIT) {
            this.searchForTableTags(entryName, htmlBody, trimStartPosition, trimEndPosition);
        }
        String htmlBodyToReplace = this.appendIncompleteTags(htmlBody, entryName, index, trimStartPosition, trimEndPosition);
        htmlBodyToReplace = this.replaceImgTag(htmlBodyToReplace);
        fileContentStr = fileContentStr.replace(htmlBody, htmlBodyToReplace);
        if (Optionals.cssStatus == CssStatus.DISTRIBUTE) {
            fileContentStr = this.dissolveStyleTag(fileContentStr);
        }
        bookSection.setSectionContent(fileContentStr);
        return bookSection;
    }

    private BookSection prepareTrimmedBookSection(NavPoint entryNavPoint, int index) throws ReadingException, OutOfPagesException {
        BookSection bookSection = new BookSection();
        String entryName = entryNavPoint.getEntryName();
        int bodyTrimStartPosition = entryNavPoint.getBodyTrimStartPosition();
        int bodyTrimEndPosition = entryNavPoint.getBodyTrimEndPosition();
        String fileContent = this.readFileContent(entryName);
        String htmlBody = this.getHtmlBody(fileContent);
        String htmlBodyToReplace = null;
        if (!entryNavPoint.isCalculated()) {
            int calculatedTrimEndPosition;
            String nextAnchor = this.getNextAnchor(index, entryName);
            if (nextAnchor != null) {
                String nextAnchorHtml = this.convertAnchorToHtml(nextAnchor);
                int anchorIndex = htmlBody.indexOf(nextAnchorHtml);
                if (anchorIndex != -1 && bodyTrimStartPosition <= anchorIndex) {
                    while (htmlBody.charAt(anchorIndex) != '<') {
                        --anchorIndex;
                    }
                    bodyTrimEndPosition = anchorIndex;
                } else {
                    bodyTrimEndPosition = this.getNextAvailableAnchorIndex(index, entryName, bodyTrimStartPosition, htmlBody);
                    if (bodyTrimEndPosition == -1) {
                        return this.getBookSection(index);
                    }
                }
            }
            if ((calculatedTrimEndPosition = this.calculateTrimEndPosition(entryName, htmlBody, bodyTrimStartPosition, bodyTrimEndPosition)) != -1) {
                bodyTrimEndPosition = calculatedTrimEndPosition;
                NavPoint nextEntryNavPoint = new NavPoint();
                nextEntryNavPoint.setTypeCode(2);
                nextEntryNavPoint.setEntryName(entryName);
                nextEntryNavPoint.setBodyTrimStartPosition(bodyTrimEndPosition);
                this.getToc().getNavMap().getNavPoints().add(index + 1, nextEntryNavPoint);
            }
        }
        if (Optionals.cssStatus == CssStatus.OMIT) {
            this.searchForTableTags(entryName, htmlBody, bodyTrimStartPosition, bodyTrimEndPosition);
        }
        htmlBodyToReplace = this.appendIncompleteTags(htmlBody, entryName, index, bodyTrimStartPosition, bodyTrimEndPosition);
        htmlBodyToReplace = this.replaceImgTag(htmlBodyToReplace);
        if (Optionals.isIncludingTextContent) {
            bookSection.setSectionTextContent(this.getOnlyTextContent(entryName, htmlBody, bodyTrimStartPosition, bodyTrimEndPosition));
        }
        fileContent = fileContent.replace(htmlBody, htmlBodyToReplace);
        if (Optionals.cssStatus == CssStatus.DISTRIBUTE) {
            fileContent = this.dissolveStyleTag(fileContent);
        }
        bookSection.setSectionContent(fileContent);
        if (this.lastBookSectionInfo != null) {
            bookSection.setExtension(this.lastBookSectionInfo.getExtension());
            bookSection.setLabel(this.lastBookSectionInfo.getLabel());
            bookSection.setMediaType(this.lastBookSectionInfo.getMediaType());
        }
        return bookSection;
    }

    private void calculateEntryTagPositions(String entryName, String htmlBody) {
        ArrayList tagList = new ArrayList();
        this.entryTagPositions.put(entryName, tagList);
        ArrayList<Tag> openedTags = null;
        ListIterator listIterator = null;
        boolean isPossiblyTagOpened = false;
        StringBuilder possiblyTag = new StringBuilder();
        Pattern pattern = Pattern.compile("<(\"[^\"]*\"|'[^']*'|[^'\">])*>");
        for (int i = 0; i < htmlBody.length(); ++i) {
            if (htmlBody.charAt(i) == '<') {
                isPossiblyTagOpened = true;
                possiblyTag.setLength(0);
            } else if (htmlBody.charAt(i) == '>') {
                String tagName;
                Matcher matcher;
                String tagStr;
                possiblyTag.append('>');
                if (htmlBody.charAt(i - 1) != '/') {
                    tagStr = possiblyTag.toString();
                    matcher = pattern.matcher(tagStr);
                    if (matcher.matches()) {
                        if (tagStr.charAt(1) == '/') {
                            String tagName2 = this.getFullTagName(tagStr, false);
                            listIterator = openedTags.listIterator(openedTags.size());
                            while (listIterator.hasPrevious()) {
                                Tag openedTag = (Tag)listIterator.previous();
                                if (!openedTag.getTagName().equals(tagName2)) continue;
                                this.addEntryTagPosition(entryName, openedTag.getFullTagName(), openedTag.getOpeningTagStartPosition(), i - tagName2.length() - 1);
                                listIterator.remove();
                                break;
                            }
                        } else {
                            if (openedTags == null) {
                                openedTags = new ArrayList<Tag>();
                            }
                            String fullTagName = this.getFullTagName(tagStr, true);
                            tagName = this.getTagName(fullTagName);
                            Tag tag = new Tag();
                            tag.setTagName(tagName);
                            tag.setFullTagName(fullTagName);
                            tag.setOpeningTagStartPosition(i - fullTagName.length());
                            openedTags.add(tag);
                        }
                    }
                } else {
                    tagStr = possiblyTag.toString();
                    matcher = pattern.matcher(tagStr);
                    if (matcher.matches()) {
                        int closingBracletIndex = tagStr.indexOf(62);
                        tagName = tagStr.substring(1, closingBracletIndex - 1);
                        this.addEntryTagPosition(entryName, tagName, i - tagName.length() - 1, i - tagName.length() - 1);
                    }
                }
                possiblyTag.setLength(0);
                isPossiblyTagOpened = false;
            }
            if (!isPossiblyTagOpened) continue;
            possiblyTag.append(htmlBody.charAt(i));
        }
    }

    private void addEntryTagPosition(String entryName, String fullTagName, int openingPosition, int closingPosition) {
        int index;
        Tag tag = new Tag();
        tag.setOpeningTagStartPosition(openingPosition);
        tag.setClosingTagStartPosition(closingPosition);
        tag.setFullTagName(fullTagName);
        tag.setTagName(this.getTagName(fullTagName));
        List<Tag> tagList = this.entryTagPositions.get(entryName);
        for (index = tagList.size(); index > 0 && tagList.get(index - 1).getOpeningTagStartPosition() > openingPosition; --index) {
        }
        tagList.add(index, tag);
    }

    private String getFullTagName(String tag, boolean isOpeningTag) {
        int closingBracletIndex = tag.indexOf(62);
        if (isOpeningTag) {
            return tag.substring(1, closingBracletIndex);
        }
        return tag.substring(2, closingBracletIndex);
    }

    private String getTagName(String fullTagName) {
        if (fullTagName.contains(" ")) {
            int endIndex;
            fullTagName = fullTagName.trim();
            for (endIndex = 1; fullTagName.length() > endIndex && fullTagName.charAt(endIndex) != ' '; ++endIndex) {
            }
            return fullTagName.substring(0, endIndex);
        }
        return fullTagName;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Pair<Integer, Integer> getNextAvailableAnchorIndex2(int index, String entryName, String htmlBody, String href, String fileName) throws ReadingException, OutOfPagesException {
        boolean isNavigatingToNextFile = false;
        String currentAnchor = null;
        String nextAnchor = null;
        boolean isFileReadFirstTime = this.isFileReadFirstTime(index, entryName);
        if (isFileReadFirstTime) {
            NavPoint currentEntryNavPoint = new NavPoint();
            currentEntryNavPoint.setTypeCode(0);
            currentEntryNavPoint.setContentSrc(fileName);
            this.getToc().getNavMap().getNavPoints().add(index, currentEntryNavPoint);
            nextAnchor = href.replace(fileName, "");
        } else {
            currentAnchor = href.replace(fileName, "");
            nextAnchor = this.getNextAnchor(index, entryName);
        }
        currentAnchor = this.convertAnchorToHtml(currentAnchor);
        nextAnchor = this.convertAnchorToHtml(nextAnchor);
        if (currentAnchor != null && nextAnchor != null) {
            int nextAnchorIndex;
            int currentAnchorIndex = htmlBody.indexOf(currentAnchor);
            if (currentAnchorIndex > (nextAnchorIndex = htmlBody.indexOf(nextAnchor))) {
                int tmp = currentAnchorIndex;
                currentAnchorIndex = nextAnchorIndex;
                nextAnchorIndex = tmp;
                Collections.swap(this.getToc().getNavMap().getNavPoints(), index, index + 1);
            }
            if (currentAnchorIndex == -1 || nextAnchorIndex == -1) {
                int tmpIndex = index;
                if (currentAnchorIndex == -1 && nextAnchorIndex == -1) {
                    this.getToc().getNavMap().getNavPoints().get(tmpIndex++).setMarkedToDelete(true);
                    this.getToc().getNavMap().getNavPoints().get(tmpIndex++).setMarkedToDelete(true);
                    currentAnchor = null;
                    nextAnchor = null;
                } else if (currentAnchorIndex == -1) {
                    this.getToc().getNavMap().getNavPoints().get(tmpIndex++).setMarkedToDelete(true);
                    currentAnchor = nextAnchor;
                } else if (nextAnchorIndex == -1) {
                    this.getToc().getNavMap().getNavPoints().get(++tmpIndex).setMarkedToDelete(true);
                    nextAnchor = null;
                }
                int markedNavPoints = tmpIndex - index;
                while (tmpIndex < this.getToc().getNavMap().getNavPoints().size()) {
                    boolean isCurrentNavPointMarked = true;
                    String possiblyNextEntryName = this.getNavPoint(tmpIndex).getContentSrc();
                    if (possiblyNextEntryName.startsWith(fileName) && possiblyNextEntryName.replace(fileName, "").startsWith("%23")) {
                        String anchor = possiblyNextEntryName.replace(fileName, "");
                        if (htmlBody.contains(anchor = this.convertAnchorToHtml(anchor))) {
                            if (currentAnchor == null) {
                                currentAnchor = anchor;
                                isCurrentNavPointMarked = false;
                            } else {
                                nextAnchor = anchor;
                                break;
                            }
                        }
                    } else {
                        isNavigatingToNextFile = true;
                        break;
                    }
                    if (isCurrentNavPointMarked) {
                        this.getToc().getNavMap().getNavPoints().get(tmpIndex).setMarkedToDelete(true);
                        ++markedNavPoints;
                    }
                    ++tmpIndex;
                }
                if (markedNavPoints != 0) {
                    if (markedNavPoints == this.getToc().getNavMap().getNavPoints().size()) {
                        throw new ReadingException("There are no items left in TOC. Toc.ncx file is probably malformed.");
                    }
                    Iterator<NavPoint> iterator = this.getToc().getNavMap().getNavPoints().iterator();
                    while (iterator.hasNext()) {
                        NavPoint navPointToDelete = iterator.next();
                        if (!navPointToDelete.isMarkedToDelete()) continue;
                        iterator.remove();
                        if (--markedNavPoints != 0) continue;
                    }
                    this.peakPage -= markedNavPoints;
                }
            }
        }
        if (isNavigatingToNextFile) {
            return null;
        }
        return this.getAnchorsInterval(htmlBody, currentAnchor, nextAnchor);
    }

    private int getNextAvailableAnchorIndex(int index, String entryName, int bodyTrimStartPosition, String htmlBody) throws ReadingException, OutOfPagesException {
        this.getToc().getNavMap().getNavPoints().remove(++index);
        int markedNavPoints = 0;
        int anchorIndex = -1;
        boolean isNextAnchorFound = false;
        boolean isNavigatingToNextFile = false;
        while (index < this.getToc().getNavMap().getNavPoints().size()) {
            String fileName;
            String possiblyNextEntryName = this.getNavPoint(index).getContentSrc();
            if (possiblyNextEntryName.startsWith(fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(entryName, '/'))) && possiblyNextEntryName.replace(fileName, "").startsWith("%23")) {
                String anchor = possiblyNextEntryName.replace(fileName, "");
                String anchorHtml = this.convertAnchorToHtml(anchor);
                anchorIndex = htmlBody.indexOf(anchorHtml);
                if (anchorIndex != -1) {
                    while (htmlBody.charAt(anchorIndex) != '<') {
                        --anchorIndex;
                    }
                    if (bodyTrimStartPosition <= anchorIndex) {
                        isNextAnchorFound = true;
                        break;
                    }
                }
            } else {
                isNavigatingToNextFile = true;
                break;
            }
            this.getToc().getNavMap().getNavPoints().get(index).setMarkedToDelete(true);
            ++markedNavPoints;
            ++index;
        }
        if (markedNavPoints != 0) {
            Iterator<NavPoint> iterator = this.getToc().getNavMap().getNavPoints().iterator();
            while (iterator.hasNext()) {
                NavPoint navPointToDelete = iterator.next();
                if (!navPointToDelete.isMarkedToDelete()) continue;
                iterator.remove();
                if (--markedNavPoints != 0) continue;
                break;
            }
            this.peakPage -= markedNavPoints;
        }
        if (isNavigatingToNextFile) {
            return -1;
        }
        if (isNextAnchorFound) {
            return anchorIndex;
        }
        return 0;
    }

    private String prepareOpeningTags(List<Tag> openedTags) {
        StringBuilder openingTagsBuilder = new StringBuilder();
        ListIterator<Tag> iterator = openedTags.listIterator();
        while (iterator.hasNext()) {
            openingTagsBuilder.append('<').append(iterator.next().getFullTagName()).append('>');
        }
        return openingTagsBuilder.toString();
    }

    private String prepareClosingTags(List<Tag> openedTags) {
        StringBuilder closingTagsBuilder = new StringBuilder();
        ListIterator<Tag> iterator = openedTags.listIterator(openedTags.size());
        while (iterator.hasPrevious()) {
            closingTagsBuilder.append("</").append(iterator.previous().getTagName()).append('>');
        }
        return closingTagsBuilder.toString();
    }

    private int calculateTrimEndPosition(String entryName, String htmlBody, int trimStartPosition, int trimEndPos) {
        int tableEndIndex;
        int tableStartIndex;
        int trimEndPosition = trimEndPos != 0 && trimEndPos - trimStartPosition < Optionals.maxContentPerSection ? trimEndPos : trimStartPosition + Optionals.maxContentPerSection;
        int htmlBodyLength = htmlBody.length();
        if (htmlBodyLength < trimEndPosition || trimEndPosition - trimStartPosition < Optionals.maxContentPerSection) {
            return -1;
        }
        List<Tag> tagStartEndPositions = this.getTagStartEndPositions(entryName, htmlBody);
        int loopCount = 0;
        int lastTagsLength = 0;
        while (true) {
            int tagsLength = 0;
            for (Tag tag : tagStartEndPositions) {
                if (tag.getOpeningTagStartPosition() > trimEndPosition) break;
                if (tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition()) {
                    if (tag.getOpeningTagStartPosition() <= trimStartPosition || tag.getOpeningTagStartPosition() >= trimEndPosition) continue;
                    tagsLength += tag.getFullTagName().length() + 3;
                    continue;
                }
                if (tag.getOpeningTagStartPosition() > trimStartPosition && tag.getOpeningTagStartPosition() < trimEndPosition) {
                    tagsLength += tag.getFullTagName().length() + 2;
                }
                if (tag.getClosingTagStartPosition() <= trimStartPosition || tag.getClosingTagStartPosition() >= trimEndPosition) continue;
                tagsLength += tag.getTagName().length() + 3;
            }
            if (lastTagsLength == tagsLength) {
                if (loopCount != 0 || tagsLength == 0 && htmlBodyLength > trimEndPosition) break;
                return -1;
            }
            if ((trimEndPosition += tagsLength) >= htmlBodyLength) {
                return -1;
            }
            if (trimEndPosition - trimStartPosition - tagsLength >= Optionals.maxContentPerSection) break;
            lastTagsLength = tagsLength;
            ++loopCount;
        }
        trimEndPosition = (tableStartIndex = htmlBody.indexOf("<table", trimStartPosition)) != -1 && tableStartIndex < trimEndPosition ? ((tableEndIndex = htmlBody.indexOf("</table>", tableStartIndex)) != -1 ? tableEndIndex + "</table>".length() : this.findEligibleEndPosition(tagStartEndPositions, htmlBody, trimEndPosition)) : this.findEligibleEndPosition(tagStartEndPositions, htmlBody, trimEndPosition);
        return trimEndPosition;
    }

    private int findEligibleEndPosition(List<Tag> tagStartEndPositions, String htmlBody, int trimEndPosition) {
        boolean isMovedToEndOfTag = false;
        for (Tag tag : tagStartEndPositions) {
            if (tag.getOpeningTagStartPosition() > trimEndPosition) break;
            if (tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition()) {
                if (tag.getOpeningTagStartPosition() >= trimEndPosition || tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 2 <= trimEndPosition) continue;
                while (htmlBody.charAt(trimEndPosition) != '>') {
                    ++trimEndPosition;
                }
                ++trimEndPosition;
                isMovedToEndOfTag = true;
                break;
            }
            if (tag.getOpeningTagStartPosition() < trimEndPosition && tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 1 > trimEndPosition) {
                while (htmlBody.charAt(trimEndPosition) != '<') {
                    --trimEndPosition;
                }
                isMovedToEndOfTag = true;
                break;
            }
            if (tag.getClosingTagStartPosition() >= trimEndPosition || tag.getClosingTagStartPosition() + tag.getTagName().length() + 2 <= trimEndPosition) continue;
            while (htmlBody.charAt(trimEndPosition) != '>') {
                ++trimEndPosition;
            }
            ++trimEndPosition;
            isMovedToEndOfTag = true;
            break;
        }
        if (!isMovedToEndOfTag) {
            while (htmlBody.charAt(trimEndPosition) != ' ') {
                if (htmlBody.charAt(--trimEndPosition) == '>') {
                    ++trimEndPosition;
                    break;
                }
                if (htmlBody.charAt(trimEndPosition) != '<') continue;
                break;
            }
        }
        return trimEndPosition;
    }

    private String getNextAnchor(int index, String entryName) throws ReadingException, OutOfPagesException {
        String fileName;
        String nextHref;
        NavPoint nextNavPoint;
        if (this.getToc().getNavMap().getNavPoints().size() > index + 1 && (nextNavPoint = this.getNavPoint(index + 1)).getTypeCode() != 2 && (nextHref = nextNavPoint.getContentSrc()) != null && nextHref.startsWith(fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(entryName, '/'))) && nextHref.replace(fileName, "").startsWith("%23")) {
            return nextHref.replace(fileName, "");
        }
        return null;
    }

    private boolean isFileReadFirstTime(int index, String entryName) throws ReadingException, OutOfPagesException {
        if (index - 1 >= 0) {
            String fileName;
            NavPoint prevNavPoint = this.getNavPoint(index - 1);
            if (prevNavPoint.getTypeCode() == 2) {
                return false;
            }
            String prevHref = prevNavPoint.getContentSrc();
            if (prevHref != null && prevHref.startsWith(fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(entryName, '/')))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContent(String entryName) throws ReadingException {
        ZipFile epubFile = null;
        try {
            epubFile = new ZipFile(this.zipFilePath);
            ZipEntry zipEntry = epubFile.getEntry(entryName);
            InputStream inputStream = epubFile.getInputStream(zipEntry);
            StringBuilder fileContent = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    fileContent.append(line).append(" ");
                }
            }
            String fileContentStr = fileContent.toString();
            fileContentStr = Optionals.cssStatus != CssStatus.OMIT ? this.replaceCssLinkWithActualCss(epubFile, fileContentStr) : this.removeStyleTags(fileContentStr);
            if (Optionals.isOmittingTitleTag) {
                fileContentStr = this.removeTitleTags(fileContentStr);
            }
            String string = fileContentStr;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ReadingException("IOException while reading content " + entryName + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new ReadingException("ParserConfigurationException while reading content " + entryName + e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new ReadingException("SAXException while reading content " + entryName + e.getMessage());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new ReadingException("TransformerException while reading content " + entryName + e.getMessage());
        }
        finally {
            try {
                if (epubFile != null) {
                    epubFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReadingException("Error closing ZipFile: " + e.getMessage());
            }
        }
    }

    private String getHtmlBody(String htmlContent) throws ReadingException {
        int startOfBody = htmlContent.lastIndexOf("<body");
        int endOfBody = htmlContent.lastIndexOf("</body>");
        int bodyStartEndIndex = startOfBody + "<body".length();
        while (htmlContent.charAt(bodyStartEndIndex) != '>') {
            ++bodyStartEndIndex;
        }
        if (startOfBody != -1 && endOfBody != -1) {
            return htmlContent.substring(bodyStartEndIndex + 1, endOfBody);
        }
        throw new ReadingException("Exception while getting book section : Html body tags not found.");
    }

    private Pair<Integer, Integer> getAnchorsInterval(String htmlBody, String currentAnchor, String nextAnchor) throws ReadingException {
        int startOfCurrentAnchor = -1;
        int startOfNextAnchor = -1;
        if (currentAnchor != null && !currentAnchor.equals("")) {
            startOfCurrentAnchor = htmlBody.indexOf(currentAnchor);
        }
        if (nextAnchor != null && !nextAnchor.equals("")) {
            startOfNextAnchor = htmlBody.indexOf(nextAnchor);
        }
        if (startOfCurrentAnchor != -1) {
            while (htmlBody.charAt(startOfCurrentAnchor) != '<') {
                --startOfCurrentAnchor;
            }
        } else {
            startOfCurrentAnchor = 0;
        }
        if (startOfNextAnchor != -1) {
            while (htmlBody.charAt(startOfNextAnchor) != '<') {
                --startOfNextAnchor;
            }
        } else {
            startOfNextAnchor = 0;
        }
        return new Pair<Integer, Integer>(startOfCurrentAnchor, startOfNextAnchor);
    }

    private String convertAnchorToHtml(String anchor) throws ReadingException {
        if (anchor == null) {
            return null;
        }
        if (anchor.startsWith("%23")) {
            return "id=\"" + anchor.substring(3) + "\"";
        }
        throw new ReadingException("Anchor does not start with #");
    }

    private String getMediaType(String fileName) {
        List<BaseFindings.XmlItem> manifestItems = this.getPackage().getManifest().getXmlItemList();
        for (int i = 0; i < manifestItems.size(); ++i) {
            if (!manifestItems.get(i).getAttributes().containsValue(fileName) || !manifestItems.get(i).getAttributes().containsKey("media-type")) continue;
            return manifestItems.get(i).getAttributes().get("media-type");
        }
        return null;
    }

    private String dissolveStyleTag(String trimmedFileContent) throws ReadingException {
        Pattern cssPattern = Pattern.compile("<style(.*?)>(.*?)</style>");
        Matcher matcher = cssPattern.matcher(trimmedFileContent);
        while (matcher.find()) {
            String styleTagStr = matcher.group(2);
            Map<String, String> cssMap = this.getCssMap(styleTagStr);
            String htmlBody = this.getHtmlBody(trimmedFileContent);
            String htmlBodyToReplace = this.putCssIntoTags(cssMap, htmlBody);
            trimmedFileContent = trimmedFileContent.replace(htmlBody, htmlBodyToReplace);
            trimmedFileContent = trimmedFileContent.replace("<style" + styleTagStr + "</style>", "");
        }
        return trimmedFileContent;
    }

    private Map<String, String> getCssMap(String cssfileContent) {
        HashMap<String, String> cssMap = new HashMap<String, String>();
        Pattern cssPattern = Pattern.compile("\\{(.*?)\\}");
        Matcher matcher = cssPattern.matcher(cssfileContent);
        while (matcher.find()) {
            String cssValue = matcher.group(1);
            int indexOfCurlyStart = matcher.start();
            StringBuilder cssNameBuilder = new StringBuilder();
            String cssName = null;
            for (int indexOfCssNameStart = indexOfCurlyStart - 1; indexOfCssNameStart >= 0; --indexOfCssNameStart) {
                String builtCssName;
                if ((cssfileContent.charAt(indexOfCssNameStart) == '}' || cssfileContent.charAt(indexOfCssNameStart) == '/') && (builtCssName = cssNameBuilder.toString().trim()).length() > 0) {
                    cssName = cssNameBuilder.reverse().toString().trim();
                    break;
                }
                cssNameBuilder.append(cssfileContent.charAt(indexOfCssNameStart));
            }
            List<String> cssNameList = null;
            String seperator = null;
            if (cssName.contains(",")) {
                seperator = ",";
            } else if (cssName.contains(">")) {
                seperator = ">";
            } else if (cssName.contains(" ")) {
                seperator = " ";
            }
            if (seperator != null) {
                cssNameList = Arrays.asList(cssName.split(seperator));
            }
            if (cssNameList == null) {
                if (cssMap.containsKey(cssName)) {
                    cssMap.put(cssName, (String)cssMap.get(cssName) + " " + cssValue);
                    continue;
                }
                cssMap.put(cssName, cssValue);
                continue;
            }
            for (String cssNameItem : cssNameList) {
                if (cssMap.containsKey(cssNameItem)) {
                    cssMap.put(cssNameItem, (String)cssMap.get(cssNameItem) + " " + cssValue);
                    continue;
                }
                cssMap.put(cssNameItem, cssValue);
            }
        }
        return cssMap;
    }

    private String putCssIntoTags(Map<String, String> cssMap, String trimmedHtmlBody) {
        for (Map.Entry<String, String> cssEntry : cssMap.entrySet()) {
            String tagName = cssEntry.getKey();
            String className = null;
            int classNameLength = 0;
            int dotIndex = cssEntry.getKey().indexOf(".");
            if (dotIndex > 0) {
                className = cssEntry.getKey().substring(dotIndex + 1);
                classNameLength = className.length();
                tagName = cssEntry.getKey().substring(0, dotIndex);
            }
            int startTagIndex = trimmedHtmlBody.indexOf("<" + tagName);
            while (startTagIndex != -1) {
                int endTagIndex = startTagIndex;
                while (trimmedHtmlBody.charAt(endTagIndex) != '>') {
                    ++endTagIndex;
                }
                if (trimmedHtmlBody.charAt(++endTagIndex - 1) != '/' && endTagIndex - startTagIndex > 5 + classNameLength) {
                    String tag = trimmedHtmlBody.substring(startTagIndex, endTagIndex);
                    if (className == null || tag.contains(className)) {
                        if (className != null) {
                            int classEndIndex = tag.indexOf(className);
                            int classStartIndex = classEndIndex - 1;
                            while (tag.charAt(classStartIndex) != 'c') {
                                --classStartIndex;
                            }
                            tag = tag.substring(0, classStartIndex) + tag.substring(classEndIndex + classNameLength + 1, tag.length());
                        }
                        int styleIndex = tag.indexOf("style=\"");
                        String tagToReplace = null;
                        if (styleIndex != -1) {
                            tagToReplace = tag.substring(0, styleIndex + 6) + cssEntry.getValue() + tag.substring(styleIndex + 6, tag.length());
                        } else {
                            int insertStyleIndex = 1 + tagName.length() + 1;
                            tagToReplace = tag.substring(0, insertStyleIndex) + "style=\"" + cssEntry.getValue() + "\" " + tag.substring(insertStyleIndex, tag.length());
                        }
                        trimmedHtmlBody = trimmedHtmlBody.replaceFirst(tag, tagToReplace);
                    }
                }
                startTagIndex = trimmedHtmlBody.indexOf("<" + tagName, startTagIndex + 1);
            }
        }
        return trimmedHtmlBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceCssLinkWithActualCss(ZipFile epubFile, String htmlContent) throws IOException, ParserConfigurationException, ReadingException, SAXException, TransformerException {
        Pattern linkTagPattern = Pattern.compile(ContextHelper.getTagsRegex("link", true));
        Pattern hrefPattern = Pattern.compile("href=\"(.*?)\"");
        Matcher linkMatcher = linkTagPattern.matcher(htmlContent);
        while (linkMatcher.find()) {
            String cssHref;
            String linkTag = linkMatcher.group(0);
            Matcher hrefMatcher = hrefPattern.matcher(linkTag);
            if (!hrefMatcher.find() || !(cssHref = ContextHelper.getTextAfterCharacter(hrefMatcher.group(1), '/')).endsWith(".css")) continue;
            if (this.nonExistingHrefList != null && this.nonExistingHrefList.contains(cssHref)) {
                htmlContent = htmlContent.replace(linkTag, "");
                continue;
            }
            boolean isCssFileFound = false;
            for (int i = 0; i < this.getEntryNames().size(); ++i) {
                String entryName = this.getEntryNames().get(i);
                String fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(entryName, '/'));
                if (!cssHref.equals(fileName)) continue;
                isCssFileFound = true;
                ZipEntry zipEntry = epubFile.getEntry(entryName);
                InputStream zipEntryInputStream = epubFile.getInputStream(zipEntry);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipEntryInputStream));
                StringBuilder fileContent = new StringBuilder();
                fileContent.append("<style type=\"text/css\">");
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        fileContent.append(line);
                    }
                }
                finally {
                    bufferedReader.close();
                }
                fileContent.append("</style>");
                htmlContent = htmlContent.replace(linkTag, fileContent.toString());
                break;
            }
            if (isCssFileFound) continue;
            System.out.println("Referenced css file not found!");
            if (this.nonExistingHrefList == null) {
                this.nonExistingHrefList = new ArrayList<String>();
            }
            this.nonExistingHrefList.add(cssHref);
            htmlContent = htmlContent.replace(cssHref, "");
        }
        return htmlContent;
    }

    private String removeStyleTags(String fileContent) {
        return this.findAndRemove(fileContent, ContextHelper.getTagsRegex("style", false));
    }

    private String removeTitleTags(String fileContent) {
        return this.findAndRemove(fileContent, ContextHelper.getTagsRegex("title", false));
    }

    private String findAndRemove(String text, String regex) {
        Pattern titleTagPattern = Pattern.compile(regex);
        Matcher titleTagMatcher = titleTagPattern.matcher(text);
        StringBuffer stringBuffer = new StringBuffer();
        while (titleTagMatcher.find()) {
            titleTagMatcher.appendReplacement(stringBuffer, "");
        }
        if (stringBuffer.length() > 0) {
            titleTagMatcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceImgTag(String htmlBody) throws ReadingException {
        Pattern imgTagPattern = Pattern.compile(ContextHelper.getTagsRegex("img", true));
        Pattern srcPattern = Pattern.compile("src=\"(.*?)\"");
        Matcher imgTagMatcher = imgTagPattern.matcher(htmlBody);
        while (imgTagMatcher.find()) {
            String imgPart = imgTagMatcher.group(0);
            Matcher srcMatcher = srcPattern.matcher(imgPart);
            if (!srcMatcher.find()) continue;
            String srcHref = ContextHelper.getTextAfterCharacter(srcMatcher.group(1), '/');
            String encodedSrcHref = ContextHelper.encodeToUtf8(srcHref);
            if (this.nonExistingHrefList != null && this.nonExistingHrefList.contains(srcHref)) {
                htmlBody = htmlBody.replace(imgPart, "");
                continue;
            }
            boolean isImageFileFound = false;
            for (int i = 0; i < this.getEntryNames().size(); ++i) {
                String entryName = this.getEntryNames().get(i);
                String fileName = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(entryName, '/'));
                if (!encodedSrcHref.equals(fileName)) continue;
                isImageFileFound = true;
                ZipFile epubFile = null;
                try {
                    String extension = ContextHelper.getTextAfterCharacter(fileName, '.');
                    epubFile = new ZipFile(this.zipFilePath);
                    ZipEntry zipEntry = epubFile.getEntry(entryName);
                    InputStream zipEntryInputStream = epubFile.getInputStream(zipEntry);
                    byte[] imageAsBytes = ContextHelper.convertIsToByteArray(zipEntryInputStream);
                    byte[] imageAsBase64 = Base64.encodeBase64((byte[])imageAsBytes);
                    String imageContent = new String(imageAsBase64);
                    String src = "data:image/" + extension + ";base64," + imageContent;
                    htmlBody = htmlBody.replace(srcHref, src);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (epubFile != null) {
                        try {
                            epubFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (isImageFileFound) continue;
            System.out.println("Referenced image file not found: " + srcHref);
            if (this.nonExistingHrefList == null) {
                this.nonExistingHrefList = new ArrayList<String>();
            }
            this.nonExistingHrefList.add(srcHref);
            htmlBody = htmlBody.replace(imgPart, "");
        }
        return htmlBody;
    }

    private void searchForTableTags(String entryName, String htmlBody, int trimStartPosition, int trimEndPosition) {
        String htmlBodyToReplace = null;
        htmlBodyToReplace = trimEndPosition == 0 ? htmlBody.substring(trimStartPosition) : htmlBody.substring(trimStartPosition, trimEndPosition);
        Pattern tableTagPattern = Pattern.compile("<table.*?>", 32);
        Matcher tableTagMatcher = tableTagPattern.matcher(htmlBodyToReplace);
        if (tableTagMatcher.find()) {
            List<Tag> tagStartEndPositions = this.getTagStartEndPositions(entryName, htmlBody);
            ArrayList<Tag> tableTagList = new ArrayList<Tag>();
            for (Tag tag : tagStartEndPositions) {
                if (tag.getOpeningTagStartPosition() > trimEndPosition) break;
                if (!tag.getTagName().equals("table") || tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition() || tag.getOpeningTagStartPosition() <= trimStartPosition || tag.getOpeningTagStartPosition() >= trimEndPosition) continue;
                tableTagList.add(tag);
            }
            ArrayList smallerTableTagList = new ArrayList();
            for (int i = 0; i < tableTagList.size(); ++i) {
                int tag1StartPosition = ((Tag)tableTagList.get(i)).getOpeningTagStartPosition();
                int tag1EndPosition = ((Tag)tableTagList.get(i)).getClosingTagStartPosition();
                for (int j = i + 1; j < tableTagList.size(); ++j) {
                    int tag2StartPosition = ((Tag)tableTagList.get(j)).getOpeningTagStartPosition();
                    int tag2EndPosition = ((Tag)tableTagList.get(j)).getClosingTagStartPosition();
                    if (tag1StartPosition > tag2StartPosition && tag1EndPosition < tag2EndPosition) {
                        smallerTableTagList.add(tableTagList.get(i));
                        continue;
                    }
                    if (tag2StartPosition <= tag1StartPosition || tag2EndPosition >= tag1EndPosition) continue;
                    smallerTableTagList.add(tableTagList.get(j));
                }
            }
            tableTagList.removeAll(smallerTableTagList);
            this.markTableTags(entryName, htmlBody, trimStartPosition, trimEndPosition, tableTagList);
        }
    }

    private void markTableTags(String entryName, String htmlBody, int trimStartPosition, int trimEndPosition, List<Tag> tableTagPositions) {
        List<Tag> tagStartEndPositions = this.getTagStartEndPositions(entryName, htmlBody);
        for (int i = 0; i < tableTagPositions.size(); ++i) {
            int tableStartPosition = tableTagPositions.get(i).getOpeningTagStartPosition() - 1;
            int tableEndPosition = tableTagPositions.get(i).getClosingTagStartPosition() - 1;
            for (Tag tag : tagStartEndPositions) {
                if (tag.getOpeningTagStartPosition() > tableEndPosition) break;
                if (tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition()) {
                    if (tag.getTagName().equals("img") || tag.getOpeningTagStartPosition() <= tableStartPosition || tag.getOpeningTagStartPosition() >= tableEndPosition) continue;
                    tag.setOmitted(true);
                    continue;
                }
                if (tag.getOpeningTagStartPosition() > tableStartPosition && tag.getOpeningTagStartPosition() < tableEndPosition) {
                    tag.setOmitted(true);
                }
                if (tag.getClosingTagStartPosition() <= tableStartPosition || tag.getClosingTagStartPosition() >= tableEndPosition) continue;
                tag.setOmitted(true);
            }
        }
    }

    private String getOnlyTextContent(String entryName, String htmlBody, int trimStartPosition, int trimEndPosition) {
        List<Tag> tagStartEndPositions = this.getTagStartEndPositions(entryName, htmlBody);
        ArrayList<String> stringsToRemove = new ArrayList<String>();
        if (trimEndPosition == 0) {
            trimEndPosition = htmlBody.length();
        }
        for (Tag tag : tagStartEndPositions) {
            if (tag.getOpeningTagStartPosition() > trimEndPosition) break;
            if (tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition()) {
                if (tag.getOpeningTagStartPosition() <= trimStartPosition || tag.getOpeningTagStartPosition() >= trimEndPosition) continue;
                htmlBody = htmlBody.substring(0, tag.getOpeningTagStartPosition() - 1) + "|" + htmlBody.substring(tag.getOpeningTagStartPosition() - 1 + "|".length(), tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 2 - "|".length()) + "|" + htmlBody.substring(tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 2, htmlBody.length());
                stringsToRemove.add("|" + htmlBody.substring(tag.getOpeningTagStartPosition() - 1 + "|".length(), tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 2 - "|".length()) + "|");
                continue;
            }
            if (tag.getOpeningTagStartPosition() > trimStartPosition && tag.getOpeningTagStartPosition() < trimEndPosition) {
                htmlBody = htmlBody.substring(0, tag.getOpeningTagStartPosition() - 1) + "|" + htmlBody.substring(tag.getOpeningTagStartPosition() - 1 + "|".length(), tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 1 - "|".length()) + "|" + htmlBody.substring(tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 1, htmlBody.length());
                stringsToRemove.add("|" + htmlBody.substring(tag.getOpeningTagStartPosition() - 1 + "|".length(), tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 1 - "|".length()) + "|");
            }
            if (tag.getClosingTagStartPosition() <= trimStartPosition || tag.getClosingTagStartPosition() >= trimEndPosition) continue;
            htmlBody = htmlBody.substring(0, tag.getClosingTagStartPosition() - 1) + "|" + htmlBody.substring(tag.getClosingTagStartPosition() - 1 + "|".length(), tag.getClosingTagStartPosition() + tag.getTagName().length() + 2 - "|".length()) + "|" + htmlBody.substring(tag.getClosingTagStartPosition() + tag.getTagName().length() + 2, htmlBody.length());
            stringsToRemove.add("|" + htmlBody.substring(tag.getClosingTagStartPosition() - 1 + "|".length(), tag.getClosingTagStartPosition() + tag.getTagName().length() + 2 - "|".length()) + "|");
        }
        htmlBody = htmlBody.substring(trimStartPosition, trimEndPosition);
        for (String stringToRemove : stringsToRemove) {
            htmlBody = htmlBody.replace(stringToRemove, "");
        }
        return htmlBody;
    }

    private String appendIncompleteTags(String htmlBody, String entryName, int index, int trimStartPosition, int trimEndPosition) throws ReadingException {
        List<String> stringsToRemove;
        Tag tag;
        if (!this.getToc().getNavMap().getNavPoints().get(index).isCalculated()) {
            this.getToc().getNavMap().getNavPoints().get(index).setBodyTrimStartPosition(trimStartPosition);
            this.getToc().getNavMap().getNavPoints().get(index).setBodyTrimEndPosition(trimEndPosition);
            this.getToc().getNavMap().getNavPoints().get(index).setEntryName(entryName);
            this.getToc().getNavMap().getNavPoints().get(index).setCalculated(true);
        }
        if (trimStartPosition == 0 && trimEndPosition == 0) {
            return htmlBody;
        }
        String htmlBodyToReplace = null;
        ArrayList<Tag> prevOpenedNotClosedYetTags = new ArrayList<Tag>();
        ArrayList<Tag> openedNotClosedYetTags = new ArrayList<Tag>();
        ArrayList<Tag> prevOpenedClosedTags = new ArrayList<Tag>();
        List<Tag> currentEntryTags = this.getTagStartEndPositions(entryName, htmlBody);
        trimEndPosition = trimEndPosition == 0 ? htmlBody.length() : trimEndPosition;
        for (int i = 0; i < currentEntryTags.size() && (tag = currentEntryTags.get(i)).getOpeningTagStartPosition() <= trimEndPosition; ++i) {
            if (tag.isOmitted() || tag.getOpeningTagStartPosition() <= trimStartPosition || tag.getOpeningTagStartPosition() >= trimEndPosition || tag.getClosingTagStartPosition() <= trimEndPosition) continue;
            openedNotClosedYetTags.add(tag);
        }
        List<Tag> prevOpenedTags = this.getToc().getNavMap().getNavPoints().get(index).getOpenTags();
        if (prevOpenedTags != null) {
            for (Tag prevOpenedTag : prevOpenedTags) {
                if (prevOpenedTag.getClosingTagStartPosition() > trimEndPosition) {
                    prevOpenedNotClosedYetTags.add(prevOpenedTag);
                    continue;
                }
                prevOpenedClosedTags.add(prevOpenedTag);
            }
        }
        Pair<String, List<String>> htmlBodyMarkingsPair = null;
        if (Optionals.cssStatus == CssStatus.OMIT && (htmlBodyMarkingsPair = this.markOmittedTags(currentEntryTags, htmlBody, trimStartPosition, trimEndPosition)) != null) {
            htmlBody = htmlBodyMarkingsPair.getFirst();
        }
        htmlBodyToReplace = trimEndPosition == htmlBody.length() ? htmlBody.substring(trimStartPosition) : htmlBody.substring(trimStartPosition, trimEndPosition);
        if (htmlBodyMarkingsPair != null && (stringsToRemove = htmlBodyMarkingsPair.getSecond()) != null) {
            for (String stringToRemove : stringsToRemove) {
                if (stringToRemove.contains("|tr")) {
                    htmlBodyToReplace = htmlBodyToReplace.replace(stringToRemove, "<br/>");
                    continue;
                }
                htmlBodyToReplace = htmlBodyToReplace.replace(stringToRemove, "");
            }
        }
        String openingTags = "";
        String closingTags = "";
        if (!openedNotClosedYetTags.isEmpty()) {
            closingTags = closingTags + this.prepareClosingTags(openedNotClosedYetTags);
        }
        if (!prevOpenedNotClosedYetTags.isEmpty()) {
            openingTags = openingTags + this.prepareOpeningTags(prevOpenedNotClosedYetTags);
            closingTags = closingTags + this.prepareClosingTags(prevOpenedNotClosedYetTags);
        }
        if (!prevOpenedClosedTags.isEmpty()) {
            openingTags = openingTags + this.prepareOpeningTags(prevOpenedClosedTags);
        }
        if (!openingTags.isEmpty() || !closingTags.isEmpty()) {
            htmlBodyToReplace = openingTags + htmlBodyToReplace + closingTags;
        }
        if (this.getToc().getNavMap().getNavPoints().size() > index + 1) {
            openedNotClosedYetTags.addAll(prevOpenedNotClosedYetTags);
            this.getToc().getNavMap().getNavPoints().get(index + 1).setOpenTags(openedNotClosedYetTags.isEmpty() ? null : openedNotClosedYetTags);
        } else {
            openedNotClosedYetTags.addAll(prevOpenedNotClosedYetTags);
            if (!openedNotClosedYetTags.isEmpty()) {
                throw new ReadingException("Last Page has opened and not yet closed tags.");
            }
        }
        return htmlBodyToReplace;
    }

    private Pair<String, List<String>> markOmittedTags(List<Tag> currentEntryTags, String htmlBody, int trimStartPosition, int trimEndPosition) {
        boolean isHtmlBodyModified = false;
        ArrayList<String> stringsToRemove = null;
        for (Tag tag : currentEntryTags) {
            if (tag.getOpeningTagStartPosition() > trimEndPosition) break;
            if (!tag.isOmitted()) continue;
            int fromIndex = -1;
            int toIndex = -1;
            if (tag.getOpeningTagStartPosition() == tag.getClosingTagStartPosition()) {
                if (tag.getOpeningTagStartPosition() > trimStartPosition && tag.getOpeningTagStartPosition() < trimEndPosition) {
                    fromIndex = tag.getOpeningTagStartPosition() - 1;
                    toIndex = tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 2;
                }
            } else {
                if (tag.getOpeningTagStartPosition() > trimStartPosition && tag.getOpeningTagStartPosition() < trimEndPosition) {
                    fromIndex = tag.getOpeningTagStartPosition() - 1;
                    toIndex = tag.getOpeningTagStartPosition() + tag.getFullTagName().length() + 1;
                }
                if (fromIndex != -1 && toIndex != -1) {
                    htmlBody = htmlBody.substring(0, fromIndex) + "|" + htmlBody.substring(fromIndex + "|".length(), toIndex - "|".length()) + "|" + htmlBody.substring(toIndex, htmlBody.length());
                    if (stringsToRemove == null) {
                        stringsToRemove = new ArrayList();
                    }
                    stringsToRemove.add("|" + htmlBody.substring(fromIndex + "|".length(), toIndex - "|".length()) + "|");
                    isHtmlBodyModified = true;
                }
                if (tag.getClosingTagStartPosition() > trimStartPosition && tag.getClosingTagStartPosition() < trimEndPosition) {
                    fromIndex = tag.getClosingTagStartPosition() - 1;
                    toIndex = tag.getClosingTagStartPosition() + tag.getTagName().length() + 2;
                }
            }
            if (fromIndex == -1 || toIndex == -1) continue;
            htmlBody = htmlBody.substring(0, fromIndex) + "|" + htmlBody.substring(fromIndex + "|".length(), toIndex - "|".length()) + "|" + htmlBody.substring(toIndex, htmlBody.length());
            if (stringsToRemove == null) {
                stringsToRemove = new ArrayList<String>();
            }
            stringsToRemove.add("|" + htmlBody.substring(fromIndex + "|".length(), toIndex - "|".length()) + "|");
            isHtmlBodyModified = true;
        }
        return isHtmlBodyModified ? new Pair<String, Object>(htmlBody, stringsToRemove) : null;
    }

    String getCoverImageFileName() {
        String coverImageId;
        if (this.opfPackage != null && this.opfPackage.getMetadata() != null && (coverImageId = this.opfPackage.getMetadata().getCoverImageId()) != null && !coverImageId.equals("")) {
            List<BaseFindings.XmlItem> manifestXmlItems = this.opfPackage.getManifest().getXmlItemList();
            for (BaseFindings.XmlItem xmlItem : manifestXmlItems) {
                if (!xmlItem.getAttributes().get("id").equals(coverImageId)) continue;
                return xmlItem.getAttributes().get("href");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] getCoverImage() throws ReadingException {
        String coverImageEntryName = this.getCoverImageFileName();
        if (coverImageEntryName == null || coverImageEntryName.equals("")) return null;
        ZipFile epubFile = null;
        try {
            try {
                epubFile = new ZipFile(this.getZipFilePath());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReadingException("Error initializing ZipFile: " + e.getMessage());
            }
            for (String entryName : this.getEntryNames()) {
                InputStream inputStream;
                if (!entryName.contains(coverImageEntryName)) continue;
                ZipEntry coverImageEntry = epubFile.getEntry(entryName);
                try {
                    inputStream = epubFile.getInputStream(coverImageEntry);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("IOException while reading " + entryName + " file: " + e.getMessage());
                }
                try {
                    byte[] e = ContextHelper.convertIsToByteArray(inputStream);
                    return e;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        throw new ReadingException("IOException while converting inputStream to byte array: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            try {
                if (epubFile != null) {
                    epubFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReadingException("Error closing ZipFile: " + e.getMessage());
            }
        }
    }

    List<String> getEntryNames() {
        return this.entryNames;
    }

    void addEntryName(String zipEntryName) {
        this.entryNames.add(zipEntryName);
    }

    Container getContainer() {
        return this.container;
    }

    Package getPackage() {
        return this.opfPackage;
    }

    Toc getToc() {
        return this.toc;
    }

    void setToc(Toc toc) {
        this.toc = toc;
    }

    void setZipFilePath(String zipFilePath) {
        this.zipFilePath = zipFilePath;
    }

    String getZipFilePath() {
        return this.zipFilePath;
    }

    List<Tag> getTagStartEndPositions(String entryName, String htmlBody) {
        if (this.entryTagPositions == null || !this.entryTagPositions.containsKey(entryName)) {
            if (this.entryTagPositions == null) {
                this.entryTagPositions = new HashMap<String, List<Tag>>();
            }
            this.calculateEntryTagPositions(entryName, htmlBody);
        }
        return this.entryTagPositions.get(entryName);
    }
}

