/*
 * Decompiled with CFR 0.152.
 */
package com.github.mertakdut;

import com.github.mertakdut.exception.ReadingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

class ContextHelper {
    ContextHelper() {
    }

    static String encodeToUtf8(String stringToEncode) throws ReadingException {
        String encodedString = null;
        try {
            encodedString = URLDecoder.decode(stringToEncode, "UTF-8");
            encodedString = URLEncoder.encode(encodedString, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ReadingException("UnsupportedEncoding while encoding, " + stringToEncode + ", : " + e.getMessage());
        }
        return encodedString;
    }

    static byte[] convertIsToByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    static String getTextAfterCharacter(String text, char character) {
        int lastCharIndex = text.lastIndexOf(character);
        return text.substring(lastCharIndex + 1);
    }

    static String getTagsRegex(String tagName, boolean isIncludingEmptyTags) {
        if (isIncludingEmptyTags) {
            return String.format("<%1$s.*?/>|<%1$s.*?</%1$s>", tagName);
        }
        return String.format("<%1$s.*?</%1$s>", tagName);
    }

    static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] BUFFER = new byte[0x400000];
        while ((bytesRead = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, bytesRead);
        }
    }
}

