/*
 * Decompiled with CFR 0.152.
 */
package com.github.mertakdut;

import com.github.mertakdut.BaseFindings;
import com.github.mertakdut.ContextHelper;
import com.github.mertakdut.exception.ReadingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Package
extends BaseFindings {
    private Metadata metadata = new Metadata();
    private Manifest manifest = new Manifest();
    private Spine spine = new Spine();
    private Guide guide = new Guide();
    private boolean isMetadataFound;
    private boolean isManifestFound;
    private boolean isSpineFound;
    private boolean isGuideFound;

    @Override
    boolean fillContent(Node node) throws ReadingException {
        String nodeName = node.getNodeName();
        if (nodeName.contains(Character.toString(':'))) {
            nodeName = ContextHelper.getTextAfterCharacter(nodeName, ':');
        }
        if (nodeName.equals("metadata")) {
            this.getMetadata().fillAttributes(node.getChildNodes());
            this.isMetadataFound = true;
        } else if (nodeName.equals("manifest")) {
            this.getManifest().fillXmlItemList(node.getChildNodes());
            this.isManifestFound = true;
        } else if (nodeName.equals("spine")) {
            this.getSpine().fillXmlItemList(node.getChildNodes());
            this.isSpineFound = true;
        } else if (nodeName.equals("guide")) {
            this.getGuide().fillXmlItemList(node.getChildNodes());
            this.isGuideFound = true;
        }
        return this.isMetadataFound && this.isManifestFound && this.isSpineFound && this.isGuideFound;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    Manifest getManifest() {
        return this.manifest;
    }

    Spine getSpine() {
        return this.spine;
    }

    Guide getGuide() {
        return this.guide;
    }

    void print() {
        this.getMetadata().print();
        this.getManifest().print();
        this.getSpine().print();
        this.getGuide().print();
    }

    public class Guide {
        private List<BaseFindings.XmlItem> xmlItemList = new ArrayList<BaseFindings.XmlItem>();

        void fillXmlItemList(NodeList nodeList) {
            this.xmlItemList = Package.this.nodeListToXmlItemList(nodeList);
        }

        public List<BaseFindings.XmlItem> getXmlItemList() {
            return this.xmlItemList;
        }

        void print() {
            System.out.println("\n\nPrinting Guide...\n");
            for (int i = 0; i < this.xmlItemList.size(); ++i) {
                BaseFindings.XmlItem xmlItem = this.xmlItemList.get(i);
                System.out.println("xmlItem(" + i + ")" + ": value:" + xmlItem.getValue() + " attributes: " + xmlItem.getAttributes());
            }
        }
    }

    public class Spine {
        private List<BaseFindings.XmlItem> xmlItemList = new ArrayList<BaseFindings.XmlItem>();

        void fillXmlItemList(NodeList nodeList) {
            this.xmlItemList = Package.this.nodeListToXmlItemList(nodeList);
        }

        public List<BaseFindings.XmlItem> getXmlItemList() {
            return this.xmlItemList;
        }

        public void print() {
            System.out.println("\n\nPrinting Spine...\n");
            for (int i = 0; i < this.xmlItemList.size(); ++i) {
                BaseFindings.XmlItem xmlItem = this.xmlItemList.get(i);
                System.out.println("xmlItem(" + i + ")" + ": value:" + xmlItem.getValue() + " attributes: " + xmlItem.getAttributes());
            }
        }
    }

    public class Manifest {
        private List<BaseFindings.XmlItem> xmlItemList = new ArrayList<BaseFindings.XmlItem>();

        void fillXmlItemList(NodeList nodeList) {
            this.xmlItemList = Package.this.nodeListToXmlItemList(nodeList);
        }

        public List<BaseFindings.XmlItem> getXmlItemList() {
            return this.xmlItemList;
        }

        public void print() {
            System.out.println("\n\nPrinting Manifest...\n");
            for (int i = 0; i < this.xmlItemList.size(); ++i) {
                BaseFindings.XmlItem xmlItem = this.xmlItemList.get(i);
                System.out.println("xmlItem(" + i + ")" + ": value:" + xmlItem.getValue() + " attributes: " + xmlItem.getAttributes());
            }
        }
    }

    public class Metadata {
        private String title;
        private String language;
        private String identifier;
        private String creator;
        private String contributor;
        private String publisher;
        private String[] subject;
        private String description;
        private String date;
        private String type;
        private String format;
        private String source;
        private String relation;
        private String coverage;
        private String rights;
        private String coverImageId;

        public String getRights() {
            return this.rights;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getContributor() {
            return this.contributor;
        }

        public String getCreator() {
            return this.creator;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLanguage() {
            return this.language;
        }

        public String[] getSubjects() {
            return this.subject;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getDate() {
            return this.date;
        }

        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public String getSource() {
            return this.source;
        }

        public String getRelation() {
            return this.relation;
        }

        public String getCoverage() {
            return this.coverage;
        }

        public String getCoverImageId() {
            return this.coverImageId;
        }

        void setCoverImageId(String coverImageId) {
            this.coverImageId = coverImageId;
        }

        void fillAttributes(NodeList nodeList) throws ReadingException {
            Field[] fields = Metadata.class.getDeclaredFields();
            ArrayList<String> subjectList = null;
            block4: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeValue() != null && node.getNodeValue().matches("\\s+")) continue;
                String nodeName = node.getNodeName();
                if (nodeName.contains(Character.toString(':'))) {
                    nodeName = ContextHelper.getTextAfterCharacter(nodeName, ':');
                }
                if (nodeName.equals("meta") && node.hasAttributes()) {
                    NamedNodeMap nodeMap = node.getAttributes();
                    boolean isCoverImageNodeFound = false;
                    for (int j = 0; j < nodeMap.getLength(); ++j) {
                        Node attribute = nodeMap.item(j);
                        if (!isCoverImageNodeFound && attribute.getNodeName().equals("name") && attribute.getNodeValue().equals("cover")) {
                            isCoverImageNodeFound = true;
                            j = -1;
                            continue;
                        }
                        if (!isCoverImageNodeFound || !attribute.getNodeName().equals("content")) continue;
                        this.coverImageId = attribute.getNodeValue();
                        break;
                    }
                }
                for (int j = 0; j < fields.length; ++j) {
                    if (!nodeName.equals(fields[j].getName())) continue;
                    if (fields[j].getName().equals("subject")) {
                        if (subjectList == null) {
                            subjectList = new ArrayList<String>();
                        }
                        subjectList.add(nodeList.item(i).getTextContent());
                        continue;
                    }
                    fields[j].setAccessible(true);
                    try {
                        fields[j].set(this, nodeList.item(i).getTextContent());
                        continue block4;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                        throw new ReadingException("Exception while parsing .opf content: " + e.getMessage());
                    }
                }
            }
            if (subjectList != null) {
                try {
                    Field field = Metadata.class.getDeclaredField("subject");
                    field.setAccessible(true);
                    field.set(this, subjectList.toArray(new String[subjectList.size()]));
                }
                catch (IllegalAccessException | IllegalArgumentException | NegativeArraySizeException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                    throw new ReadingException("Exception while parsing subjects .opf content: " + e.getMessage());
                }
            }
        }

        void print() {
            System.out.println("\n\nPrinting Metadata...\n");
            System.out.println("title: " + this.getTitle());
            System.out.println("language: " + this.getLanguage());
            System.out.println("identifier: " + this.getIdentifier());
            System.out.println("creator: " + this.getCreator());
            System.out.println("contributor: " + this.getContributor());
            System.out.println("publisher: " + this.getPublisher());
            System.out.println("subject: " + this.getSubjects());
            System.out.println("description: " + this.getDescription());
            System.out.println("date: " + this.getDate());
            System.out.println("type: " + this.getType());
            System.out.println("format: " + this.getFormat());
            System.out.println("source: " + this.getSource());
            System.out.println("relation: " + this.getRelation());
            System.out.println("coverage: " + this.getCoverage());
            System.out.println("rights: " + this.getRights());
            System.out.println("coverImageHref: " + this.coverImageId);
        }
    }
}

