/*
 * Decompiled with CFR 0.152.
 */
package com.github.mertakdut;

import com.github.mertakdut.BaseFindings;
import com.github.mertakdut.BookSection;
import com.github.mertakdut.Content;
import com.github.mertakdut.ContextHelper;
import com.github.mertakdut.CssStatus;
import com.github.mertakdut.NavPoint;
import com.github.mertakdut.Optionals;
import com.github.mertakdut.Package;
import com.github.mertakdut.Toc;
import com.github.mertakdut.exception.OutOfPagesException;
import com.github.mertakdut.exception.ReadingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Reader {
    private boolean isFoundNeeded;
    private Content content;
    private boolean isProgressFileFound;

    public void setInfoContent(String filePath) throws ReadingException {
        this.fillContent(filePath, false, false);
    }

    public void setFullContent(String filePath) throws ReadingException {
        this.fillContent(filePath, true, false);
    }

    public int setFullContentWithProgress(String filePath) throws ReadingException {
        this.fillContent(filePath, true, true);
        if (this.isProgressFileFound) {
            return this.loadProgress();
        }
        return 0;
    }

    public BookSection readSection(int index) throws ReadingException, OutOfPagesException {
        return this.content.maintainBookSections(index);
    }

    public void setMaxContentPerSection(int maxContentPerSection) {
        Optionals.maxContentPerSection = maxContentPerSection;
    }

    public void setCssStatus(CssStatus cssStatus) {
        Optionals.cssStatus = cssStatus;
    }

    public void setIsIncludingTextContent(boolean isIncludingTextContent) {
        Optionals.isIncludingTextContent = isIncludingTextContent;
    }

    public void setIsOmittingTitleTag(boolean isOmittingTitleTag) {
        Optionals.isOmittingTitleTag = isOmittingTitleTag;
    }

    public Package getInfoPackage() {
        return this.content.getPackage();
    }

    public Toc getToc() {
        return this.content.getToc();
    }

    public String getCoverImageFileName() throws ReadingException {
        if (this.content != null) {
            return this.content.getCoverImageFileName();
        }
        throw new ReadingException("Content info is not set.");
    }

    public byte[] getCoverImage() throws ReadingException {
        if (this.content != null) {
            return this.content.getCoverImage();
        }
        throw new ReadingException("Content info is not set.");
    }

    public void saveProgress(int lastPageIndex) throws ReadingException, OutOfPagesException {
        if (lastPageIndex >= this.content.getToc().getNavMap().getNavPoints().size()) {
            throw new OutOfPagesException(lastPageIndex, this.content.getToc().getNavMap().getNavPoints().size());
        }
        this.content.getToc().setLastPageIndex(lastPageIndex);
        this.saveProgress();
    }

    public void saveProgress() throws ReadingException {
        File newFile;
        ZipFile epubFile = null;
        ZipOutputStream zipOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        String newFilePath = null;
        try {
            epubFile = new ZipFile(this.content.getZipFilePath());
            String fileName = new File(this.content.getZipFilePath()).getName();
            newFilePath = this.content.getZipFilePath().replace(fileName, "tmp_" + fileName);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(newFilePath));
            Enumeration<? extends ZipEntry> entries = epubFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().equals("epubparser_progress.ser")) continue;
                ZipEntry destEntry = new ZipEntry(entry.getName());
                zipOutputStream.putNextEntry(destEntry);
                if (!entry.isDirectory()) {
                    ContextHelper.copy(epubFile.getInputStream(entry), zipOutputStream);
                }
                zipOutputStream.closeEntry();
            }
            ZipEntry progressFileEntry = new ZipEntry("epubparser_progress.ser");
            zipOutputStream.putNextEntry(progressFileEntry);
            objectOutputStream = new ObjectOutputStream(zipOutputStream);
            objectOutputStream.writeObject(this.content.getToc());
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
            File newFile2 = new File(newFilePath);
            if (newFile2.exists()) {
                newFile2.delete();
            }
            throw new ReadingException("Error writing progressed ZipFile: " + e.getMessage());
        }
        finally {
            if (epubFile != null) {
                try {
                    epubFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("Error closing ZipFile: " + e.getMessage());
                }
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("Error closing object output stream: " + e.getMessage());
                }
            }
        }
        File oldFile = new File(this.content.getZipFilePath());
        if (oldFile.exists()) {
            oldFile.delete();
        }
        if ((newFile = new File(newFilePath)).exists() && !oldFile.exists()) {
            newFile.renameTo(new File(this.content.getZipFilePath()));
        }
    }

    public boolean isSavedProgressFound() {
        return this.isProgressFileFound;
    }

    public int loadProgress() throws ReadingException {
        if (!this.isProgressFileFound) {
            throw new ReadingException("No save files are found. Loading progress is unavailable.");
        }
        ZipFile epubFile = null;
        InputStream saveFileInputStream = null;
        ObjectInputStream oiStream = null;
        try {
            epubFile = new ZipFile(this.content.getZipFilePath());
            ZipEntry zipEntry = epubFile.getEntry("epubparser_progress.ser");
            saveFileInputStream = epubFile.getInputStream(zipEntry);
            oiStream = new ObjectInputStream(saveFileInputStream);
            Toc toc = (Toc)oiStream.readObject();
            this.content.setToc(toc);
            int n = this.content.getToc().getLastPageIndex();
            return n;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new ReadingException("Error initializing ZipFile: " + e.getMessage());
        }
        finally {
            if (epubFile != null) {
                try {
                    epubFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("Error closing ZipFile: " + e.getMessage());
                }
            }
            if (oiStream != null) {
                try {
                    oiStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("Error closing object input stream: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content fillContent(String zipFilePath, boolean isFullContent, boolean isLoadingProgress) throws ReadingException {
        if (zipFilePath == null) {
            throw new ReadingException("Epub file path is null.");
        }
        this.content = new Content();
        this.content.setZipFilePath(zipFilePath);
        ZipFile epubFile = null;
        try {
            DocumentBuilder docBuilder;
            try {
                epubFile = new ZipFile(zipFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReadingException("Error initializing ZipFile: " + e.getMessage());
            }
            Enumeration<? extends ZipEntry> files = epubFile.entries();
            while (files.hasMoreElements()) {
                String entryName;
                ZipEntry entry = files.nextElement();
                if (entry.isDirectory() || (entryName = entry.getName()) == null) continue;
                this.content.addEntryName(entryName);
                if (!entryName.equals("epubparser_progress.ser")) continue;
                this.isProgressFileFound = true;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            try {
                factory.setFeature("http://xml.org/sax/features/namespaces", false);
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            try {
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new ReadingException("DocumentBuilder cannot be created: " + e.getMessage());
            }
            boolean isContainerXmlFound = false;
            boolean isTocXmlFound = false;
            for (int i = 0; i < this.content.getEntryNames().size() && (!isContainerXmlFound || !isTocXmlFound && isFullContent); ++i) {
                Document document;
                InputStream inputStream;
                String currentEntryName = this.content.getEntryNames().get(i);
                if (currentEntryName.contains("container.xml")) {
                    isContainerXmlFound = true;
                    ZipEntry container = epubFile.getEntry(currentEntryName);
                    try {
                        inputStream = epubFile.getInputStream(container);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new ReadingException("IOException while reading container.xml file: " + e.getMessage());
                    }
                    document = this.getDocument(docBuilder, inputStream, "container.xml");
                    this.parseContainerXml(docBuilder, document, epubFile);
                    continue;
                }
                if (isLoadingProgress && this.isProgressFileFound || !isFullContent || !currentEntryName.endsWith(".ncx")) continue;
                isTocXmlFound = true;
                ZipEntry toc = epubFile.getEntry(currentEntryName);
                try {
                    inputStream = epubFile.getInputStream(toc);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("IOException while reading .ncx file: " + e.getMessage());
                }
                document = this.getDocument(docBuilder, inputStream, ".ncx");
                this.parseTocFile(document, this.content.getToc());
            }
            if (!isContainerXmlFound) {
                throw new ReadingException("container.xml not found.");
            }
            if (!(isTocXmlFound || !isFullContent || isLoadingProgress && this.isProgressFileFound)) {
                throw new ReadingException("toc.ncx not found.");
            }
            if (!(!isFullContent || isLoadingProgress && this.isProgressFileFound)) {
                this.mergeTocElements();
            }
            Content content = this.content;
            return content;
        }
        finally {
            if (epubFile != null) {
                try {
                    epubFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReadingException("Error closing ZipFile: " + e.getMessage());
                }
            }
        }
    }

    private void parseContainerXml(DocumentBuilder docBuilder, Document document, ZipFile epubFile) throws ReadingException {
        InputStream opfFileInputStream;
        String opfFilePath;
        ZipEntry opfFileEntry;
        if (document.hasChildNodes()) {
            this.isFoundNeeded = false;
            this.traverseDocumentNodesAndFillContent(document.getChildNodes(), this.content.getContainer());
        }
        if ((opfFileEntry = epubFile.getEntry(opfFilePath = this.content.getContainer().getFullPathValue())) == null) {
            for (String entryName : this.content.getEntryNames()) {
                if (!entryName.contains(".opf")) continue;
                opfFileEntry = epubFile.getEntry(entryName);
                break;
            }
        }
        if (opfFileEntry == null) {
            throw new ReadingException(".opf file not found");
        }
        try {
            opfFileInputStream = epubFile.getInputStream(opfFileEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ReadingException("IO error while reading .opf inputstream: " + e.getMessage());
        }
        Document packageDocument = this.getDocument(docBuilder, opfFileInputStream, ".opf");
        this.parseOpfFile(packageDocument, this.content.getPackage());
    }

    private void parseOpfFile(Document document, Package pckage) throws ReadingException {
        if (document.hasChildNodes()) {
            this.isFoundNeeded = false;
            this.traverseDocumentNodesAndFillContent(document.getChildNodes(), pckage);
        }
    }

    private void parseTocFile(Document document, Toc toc) throws ReadingException {
        if (document.hasChildNodes()) {
            this.isFoundNeeded = false;
            this.traverseDocumentNodesAndFillContent(document.getChildNodes(), toc);
        }
    }

    private Document getDocument(DocumentBuilder docBuilder, InputStream inputStream, String fileName) throws ReadingException {
        try {
            Document document = docBuilder.parse(inputStream);
            inputStream.close();
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReadingException("Parse error while parsing " + fileName + " file: " + e.getMessage());
        }
    }

    private void traverseDocumentNodesAndFillContent(NodeList nodeList, BaseFindings findings) throws ReadingException {
        if (this.isFoundNeeded) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            if (tempNode.getNodeType() != 1) continue;
            this.isFoundNeeded = findings.fillContent(tempNode);
            if (this.isFoundNeeded) break;
            if (!tempNode.hasChildNodes()) continue;
            this.traverseDocumentNodesAndFillContent(tempNode.getChildNodes(), findings);
        }
    }

    private void mergeTocElements() throws ReadingException {
        ArrayList<NavPoint> currentNavPoints = new ArrayList<NavPoint>(this.content.getToc().getNavMap().getNavPoints());
        int navPointIndex = 0;
        int insertedNavPointCount = 0;
        for (BaseFindings.XmlItem spine : this.content.getPackage().getSpine().getXmlItemList()) {
            Map<String, String> spineAttributes = spine.getAttributes();
            String idRef = spineAttributes.get("idref");
            for (BaseFindings.XmlItem manifest : this.content.getPackage().getManifest().getXmlItemList()) {
                Map<String, String> manifestAttributes = manifest.getAttributes();
                String manifestElementId = manifestAttributes.get("id");
                if (!idRef.equals(manifestElementId)) continue;
                NavPoint navPoint = new NavPoint();
                navPoint.setContentSrc(ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(manifestAttributes.get("href"), '/')));
                boolean duplicateContentSrc = false;
                boolean isAnchoredFound = false;
                for (int j = 0; j < currentNavPoints.size(); ++j) {
                    NavPoint navPointItem = (NavPoint)currentNavPoints.get(j);
                    if (navPoint.getContentSrc().equals(navPointItem.getContentSrc())) {
                        duplicateContentSrc = true;
                        navPointIndex = j;
                        break;
                    }
                    if (!isAnchoredFound && navPoint.getContentSrc().startsWith(navPointItem.getContentSrc()) && navPoint.getContentSrc().replace(navPointItem.getContentSrc(), "").startsWith("%23")) {
                        isAnchoredFound = true;
                        navPointIndex = j;
                        continue;
                    }
                    if (isAnchoredFound || !navPointItem.getContentSrc().startsWith(navPoint.getContentSrc()) || !navPointItem.getContentSrc().replace(navPoint.getContentSrc(), "").startsWith("%23")) continue;
                    isAnchoredFound = true;
                    navPointIndex = j;
                }
                if (duplicateContentSrc) continue;
                this.content.getToc().getNavMap().getNavPoints().add(navPointIndex + insertedNavPointCount++, navPoint);
            }
        }
    }
}

