/*
 * Decompiled with CFR 0.152.
 */
package com.github.mertakdut;

import com.github.mertakdut.BaseFindings;
import com.github.mertakdut.ContextHelper;
import com.github.mertakdut.NavPoint;
import com.github.mertakdut.exception.ReadingException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Toc
extends BaseFindings
implements Serializable {
    private static final long serialVersionUID = 8154412879349792795L;
    private Head head = new Head();
    private NavMap navMap = new NavMap();
    private int lastPageIndex;
    private transient boolean isHeadFound;
    private transient boolean isNavMapFound;

    @Override
    boolean fillContent(Node node) throws ReadingException {
        String nodeName = node.getNodeName();
        if (nodeName.contains(Character.toString(':'))) {
            nodeName = ContextHelper.getTextAfterCharacter(nodeName, ':');
        }
        if (nodeName.equals("head")) {
            this.getHead().fillAttributes(node.getChildNodes());
            this.isHeadFound = true;
        } else if (nodeName.equals("navMap") || nodeName.equals("pageList")) {
            this.getNavMap().fillNavPoints(node.getChildNodes());
            this.getNavMap().sortNavMaps();
            this.isNavMapFound = true;
        }
        return this.isHeadFound && this.isNavMapFound;
    }

    public Head getHead() {
        return this.head;
    }

    public NavMap getNavMap() {
        return this.navMap;
    }

    void print() {
        this.getHead().print();
        this.getNavMap().print();
    }

    int getLastPageIndex() {
        return this.lastPageIndex;
    }

    void setLastPageIndex(int lastPageIndex) {
        this.lastPageIndex = lastPageIndex;
    }

    public class NavMap
    implements Serializable {
        private static final long serialVersionUID = -3629764613712749465L;
        private List<NavPoint> navPoints;

        public List<NavPoint> getNavPoints() {
            return this.navPoints;
        }

        void fillNavPoints(NodeList possiblyNavPoints) throws ReadingException {
            if (this.navPoints == null) {
                this.navPoints = new ArrayList<NavPoint>();
            }
            for (int i = 0; i < possiblyNavPoints.getLength(); ++i) {
                String navPointNodeName = possiblyNavPoints.item(i).getNodeName();
                if (navPointNodeName.contains(Character.toString(':'))) {
                    navPointNodeName = ContextHelper.getTextAfterCharacter(navPointNodeName, ':');
                }
                if (!navPointNodeName.equals("navPoint") && !navPointNodeName.equals("pageTarget")) continue;
                NavPoint navPoint = new NavPoint();
                NamedNodeMap nodeMap = possiblyNavPoints.item(i).getAttributes();
                for (int j = 0; j < nodeMap.getLength(); ++j) {
                    Node attribute = nodeMap.item(j);
                    if (attribute.getNodeName().equals("id")) {
                        navPoint.setId(attribute.getNodeValue());
                        continue;
                    }
                    if (attribute.getNodeName().equals("playOrder")) {
                        navPoint.setPlayOrder(Integer.parseInt(attribute.getNodeValue()));
                        continue;
                    }
                    if (!attribute.getNodeName().equals("type")) continue;
                    navPoint.setType(attribute.getNodeValue());
                }
                boolean hasNestedNavPoints = false;
                NodeList navPointChildNodes = possiblyNavPoints.item(i).getChildNodes();
                for (int k = 0; k < navPointChildNodes.getLength(); ++k) {
                    Node navPointChild = navPointChildNodes.item(k);
                    String navPointChildNodeName = navPointChild.getNodeName();
                    if (navPointChildNodeName.contains(Character.toString(':'))) {
                        navPointChildNodeName = ContextHelper.getTextAfterCharacter(navPointChildNodeName, ':');
                    }
                    if (navPointChildNodeName.equals("navLabel")) {
                        NodeList navLabelChildNodes = navPointChild.getChildNodes();
                        for (int l = 0; l < navLabelChildNodes.getLength(); ++l) {
                            String navLabelChildNodeName = navLabelChildNodes.item(l).getNodeName();
                            if (navLabelChildNodeName.contains(Character.toString(':'))) {
                                navLabelChildNodeName = ContextHelper.getTextAfterCharacter(navLabelChildNodeName, ':');
                            }
                            if (!navLabelChildNodeName.equals("text")) continue;
                            navPoint.setNavLabel(navLabelChildNodes.item(l).getTextContent());
                        }
                        continue;
                    }
                    if (navPointChildNodeName.equals("content")) {
                        NamedNodeMap contentAttributes = navPointChild.getAttributes();
                        for (int m = 0; m < contentAttributes.getLength(); ++m) {
                            String contentSrc;
                            Node contentAttribute = contentAttributes.item(m);
                            if (!contentAttribute.getNodeName().equals("src") || (contentSrc = contentAttribute.getNodeValue()) == null || contentSrc.equals("")) continue;
                            String encodedContentSrc = ContextHelper.encodeToUtf8(ContextHelper.getTextAfterCharacter(contentSrc, '/'));
                            navPoint.setContentSrc(encodedContentSrc);
                        }
                        continue;
                    }
                    if (hasNestedNavPoints || !navPointChildNodeName.equals("navPoint")) continue;
                    hasNestedNavPoints = true;
                }
                boolean duplicateOrNullContentSrc = false;
                for (NavPoint navPointItem : this.navPoints) {
                    if (navPoint.getContentSrc() != null && !navPoint.getContentSrc().equals(navPointItem.getContentSrc())) continue;
                    duplicateOrNullContentSrc = true;
                    break;
                }
                if (!duplicateOrNullContentSrc) {
                    this.navPoints.add(navPoint);
                }
                if (!hasNestedNavPoints) continue;
                this.fillNavPoints(navPointChildNodes);
            }
        }

        void sortNavMaps() {
            Collections.sort(this.navPoints, new Comparator<NavPoint>(){

                @Override
                public int compare(NavPoint o1, NavPoint o2) {
                    return o1.getPlayOrder() < o2.getPlayOrder() ? -1 : 1;
                }
            });
        }

        void print() {
            System.out.println("\n\nPrinting NavPoints...\n");
            for (int i = 0; i < this.navPoints.size(); ++i) {
                NavPoint navPoint = this.navPoints.get(i);
                System.out.println("navPoint (" + i + ") id: " + navPoint.getId() + ", playOrder: " + navPoint.getPlayOrder() + ", navLabel(Text): " + navPoint.getNavLabel() + ", content src: " + navPoint.getContentSrc());
            }
        }
    }

    public class Head
    implements Serializable {
        private static final long serialVersionUID = -5861717309893477622L;
        private String uid;
        private String depth;
        private String totalPageCount;
        private String maxPageNumber;

        void fillAttributes(NodeList nodeList) throws ReadingException {
            Field[] fields = Head.class.getDeclaredFields();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String metaNodeName = nodeList.item(i).getNodeName();
                if (metaNodeName.contains(Character.toString(':'))) {
                    metaNodeName = ContextHelper.getTextAfterCharacter(metaNodeName, ':');
                }
                if (!metaNodeName.equals("meta")) continue;
                NamedNodeMap attributes = nodeList.item(i).getAttributes();
                for (int k = 0; k < attributes.getLength(); ++k) {
                    Node attribute = attributes.item(k);
                    if (!attribute.getNodeName().equals("name")) continue;
                    String attributeNodeValue = attribute.getNodeValue();
                    if (attributeNodeValue.contains(Character.toString(':'))) {
                        attributeNodeValue = ContextHelper.getTextAfterCharacter(attributeNodeValue, ':');
                    }
                    block4: for (int j = 0; j < fields.length; ++j) {
                        if (!attributeNodeValue.equals(fields[j].getName())) continue;
                        for (int l = 0; l < attributes.getLength(); ++l) {
                            if (!attributes.item(l).getNodeName().equals("content")) continue;
                            fields[j].setAccessible(true);
                            try {
                                fields[j].set(this, attributes.item(l).getNodeValue());
                                continue block4;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | DOMException e) {
                                e.printStackTrace();
                                throw new ReadingException("Exception while parsing .ncx content: " + e.getMessage());
                            }
                        }
                    }
                }
            }
        }

        public String getUid() {
            return this.uid;
        }

        public String getDepth() {
            return this.depth;
        }

        public String getTotalPageCount() {
            return this.totalPageCount;
        }

        public String getMaxPageNumber() {
            return this.maxPageNumber;
        }

        void print() {
            System.out.println("\n\nPrinting Head...\n");
            System.out.println("uid: " + this.getUid());
            System.out.println("depth: " + this.getDepth());
            System.out.println("totalPageCount: " + this.getTotalPageCount());
            System.out.println("maxPageNumber: " + this.getMaxPageNumber());
        }
    }
}

