/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.BruteForce;

import com.anomalydetect.BruteForce.AlphabetTreeNode;
import com.anomalydetect.BruteForce.Notes;

public class AlphabetTree {
    private AlphabetTreeNode head;

    AlphabetTree(char initChar, int depth, int ways) {
        this.head = new AlphabetTreeNode(false, initChar, true);
    }

    public void addNote(Notes note) {
        char[] chars = note.getData();
        AlphabetTreeNode temp = this.head;
        int position = 0;
        for (char c : chars) {
            if (!temp.isHaveLabel(c)) {
                temp.getNodeList().add(new AlphabetTreeNode(position == chars.length - 1, c, false));
            }
            if (position == chars.length - 1) {
                temp.getNodeByLabel(c).getNotes().add(note);
                if (temp.getNodeByLabel(c).getNotes().size() > 1) {
                    temp.increase(c);
                }
            }
            temp = temp.getNodeByLabel(c);
            ++position;
        }
    }

    private void addNodes(AlphabetTreeNode node, char initChar, int ways, boolean isLeaf) {
        for (int i = 0; i < ways; ++i) {
            AlphabetTreeNode n = new AlphabetTreeNode(isLeaf, (char)(initChar + i), false);
            node.getNodeList().add(n);
        }
    }
}

