/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.BruteForce;

import com.anomalydetect.BruteForce.Notes;
import java.util.ArrayList;
import java.util.List;

public class AlphabetTreeNode {
    private boolean isLeaf;
    private boolean isRoot;
    private char label;
    private List<Notes> notes;
    private List<AlphabetTreeNode> nodeList;

    AlphabetTreeNode(boolean isLeaf, char label, boolean isRoot) {
        this.isLeaf = isLeaf;
        this.label = label;
        this.isRoot = isRoot;
        this.nodeList = new ArrayList<AlphabetTreeNode>();
        if (isLeaf) {
            this.notes = new ArrayList<Notes>();
        }
    }

    public boolean isHaveLabel(char label) {
        return this.getNodeByLabel(label) != null;
    }

    public AlphabetTreeNode getNodeByLabel(char label) {
        for (AlphabetTreeNode node : this.nodeList) {
            if (node.label != label) continue;
            return node;
        }
        return null;
    }

    public void increase(char label) {
        for (Notes notes : this.getNodeByLabel((char)label).notes) {
            notes.setCount(notes.getCount() + 1);
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public List<AlphabetTreeNode> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<AlphabetTreeNode> nodeList) {
        this.nodeList = nodeList;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public char getLabel() {
        return this.label;
    }

    public void setLabel(char label) {
        this.label = label;
    }

    public List<Notes> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Notes> notes) {
        this.notes = notes;
    }
}

