/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.BruteForce;

import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Tool.MathTool;
import com.anomalydetect.Tool.MultiDetectTool;
import java.util.ArrayList;
import java.util.List;

public class BruteForceTool
implements DetectTool,
MultiDetectTool {
    private ArrayList<Result> results;
    private int length;

    public BruteForceTool(int length) {
        this.length = length;
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        this.results = new ArrayList();
        double bestDist = 0.0;
        int bestLoc = -1;
        for (int p = 0; p < data.length - this.length + 1; ++p) {
            double tempDist = Double.MAX_VALUE;
            for (int q = 0; q < data.length - this.length + 1; ++q) {
                if (Math.abs(p - q) < this.length || !(MathTool.dist(data, p, q, this.length) < tempDist)) continue;
                tempDist = MathTool.dist(data, p, q, this.length);
            }
            if (!(tempDist > bestDist)) continue;
            bestDist = tempDist;
            bestLoc = p;
        }
        this.results.add(new Result(bestLoc, data[bestLoc]));
    }

    @Override
    public void multiTimeSeriesAnalyse(double[][] data, int dimension) {
        this.results = new ArrayList();
        double bestDist = 0.0;
        int bestLoc = -1;
        for (int p = 0; p < data.length - this.length + 1; ++p) {
            double tempDist = Double.MAX_VALUE;
            for (int q = 0; q < data.length - this.length + 1; ++q) {
                if (Math.abs(p - q) < this.length || !(MathTool.distForMulti(data, p, q, this.length, dimension) < tempDist)) continue;
                tempDist = MathTool.distForMulti(data, p, q, this.length, dimension);
            }
            if (!(tempDist > bestDist)) continue;
            bestDist = tempDist;
            bestLoc = p;
        }
        this.results.add(new Result(bestLoc, data[bestLoc]));
    }

    @Override
    public List<Result> getResults() {
        return this.results;
    }

    public void setResults(ArrayList<Result> results) {
        this.results = results;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

