/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.BruteForce;

import com.anomalydetect.BruteForce.AlphabetTree;
import com.anomalydetect.BruteForce.Notes;
import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Tool.MathTool;
import java.util.ArrayList;
import java.util.List;

public class HeuristicTool
implements DetectTool {
    private int w;
    private int a = 3;
    private List<Result> results;
    private char initChar = (char)97;

    HeuristicTool(int w) {
        this.w = w;
        this.results = new ArrayList<Result>();
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        double[] nums = MathTool.gassian(data);
        char[] chars = this.saxConvert(nums);
        this.results = new ArrayList<Result>();
        ArrayList<Notes> notes = new ArrayList<Notes>();
        AlphabetTree tree = new AlphabetTree(this.initChar, this.w, this.a);
        for (int i = 0; i < data.length - this.w + 1; ++i) {
            Notes n = new Notes(this.w, chars, i, i);
            notes.add(n);
            tree.addNote(n);
        }
        int index = this.findMinCount(notes);
        this.doTheHeuristicAnalysis(nums, index, this.w, notes);
    }

    private void doTheHeuristicAnalysis(double[] data, int index, int length, ArrayList<Notes> notes) {
        double bestDist = 0.0;
        int bestLoc = -1;
        notes.get(index).setVisited(true);
        double tempDist = Double.MAX_VALUE;
        for (int q = 0; q < data.length - length + 1; ++q) {
            if (Math.abs(index - q) < length || !(MathTool.dist(data, index, q, length) < tempDist)) continue;
            tempDist = MathTool.dist(data, index, q, length);
        }
        if (tempDist > bestDist) {
            bestDist = tempDist;
            bestLoc = index;
        }
        for (int p = 0; p < data.length - length + 1; ++p) {
            if (notes.get(p).isVisited()) continue;
            tempDist = Double.MAX_VALUE;
            for (int q = 0; q < data.length - length + 1; ++q) {
                if (Math.abs(p - q) >= length && MathTool.dist(data, p, q, length) < bestDist) {
                    if (tempDist != Double.MAX_VALUE) break;
                    tempDist = Double.MIN_VALUE;
                    break;
                }
                if (Math.abs(p - q) < length || !(MathTool.dist(data, p, q, length) < tempDist)) continue;
                tempDist = MathTool.dist(data, p, q, length);
            }
            if (!(tempDist > bestDist)) continue;
            bestDist = tempDist;
            bestLoc = p;
        }
        this.results.add(new Result(bestLoc, data[bestLoc]));
    }

    private int findMinCount(ArrayList<Notes> notes) {
        int min = Integer.MAX_VALUE;
        int index = 0;
        int count = 0;
        for (Notes n : notes) {
            if (min > n.getCount()) {
                min = n.getCount();
                index = count;
            }
            ++count;
        }
        return index;
    }

    private char[] saxConvert(double[] data) {
        char[] result = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = this.alphabetConvert(data[i]);
        }
        return result;
    }

    private char alphabetConvert(double datum) {
        if (datum >= -0.43 && datum <= 0.43) {
            return 'b';
        }
        if (datum < -0.43) {
            return 'a';
        }
        return 'c';
    }

    @Override
    public List<Result> getResults() {
        return this.results;
    }

    public void setResults(List<Result> results) {
        this.results = results;
    }

    public char getInitChar() {
        return this.initChar;
    }

    public void setInitChar(char initChar) {
        this.initChar = initChar;
    }
}

