/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.ESD;

import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Tool.MathTool;
import java.util.ArrayList;

public class ESDTool
implements DetectTool {
    private double average;
    private double stdDeviation;
    private int K;
    private double t;
    private double[] g;
    private ArrayList<Result> results;

    ESDTool(int k) {
        this.K = k;
        this.g = new double[k];
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        this.initG(data);
        this.average = MathTool.getAverageFromArray(data);
        this.stdDeviation = MathTool.getStdDeviation(data);
        this.K = 1;
        while (this.K <= data.length) {
            ArrayList<Result> tempResults = new ArrayList<Result>();
            double kValue = this.getKExtremeValue(data, this.K);
            int n = data.length;
            int count = 0;
            for (int i = 0; i < data.length; ++i) {
                this.t = Math.abs(data[i] - this.average) / (this.stdDeviation / Math.sqrt(n - this.K));
                double lambda = (double)(n - this.K) * this.t / Math.sqrt(((double)(n - this.K - 1) + this.t * this.t) * (double)(n - this.K + 1));
                if (!(lambda < kValue)) continue;
                tempResults.add(new Result(i, data[i]));
                ++count;
            }
            if (count == this.K) {
                this.results = tempResults;
            }
            ++this.K;
        }
    }

    private void initG(double[] data) {
        double[] temp = (double[])data.clone();
        double tempAvg = MathTool.getAverageFromArray(temp);
        double tempS = MathTool.getStdDeviation(temp);
        for (int i = 0; i < this.K; ++i) {
        }
    }

    public double getKExtremeValue(double[] data, int k) {
        int i;
        double[] temp = (double[])data.clone();
        for (i = 0; i < data.length; ++i) {
            temp[i] = Math.abs(temp[i] - this.average) / this.stdDeviation;
        }
        for (i = 0; i < k + 1; ++i) {
            for (int j = i + 1; j < data.length; ++j) {
                if (!(temp[i] < temp[j])) continue;
                double c = temp[i];
                temp[i] = temp[j];
                temp[j] = c;
            }
        }
        return temp[k - 1];
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public void setStdDeviation(double stdDeviation) {
        this.stdDeviation = stdDeviation;
    }

    public int getK() {
        return this.K;
    }

    public void setK(int k) {
        this.K = k;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double t) {
        this.t = t;
    }

    public ArrayList<Result> getResults() {
        return this.results;
    }

    public void setResults(ArrayList<Result> results) {
        this.results = results;
    }

    public double[] getG() {
        return this.g;
    }

    public void setG(double[] g) {
        this.g = g;
    }
}

