/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.ESD;

import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Tool.MathTool;
import java.util.ArrayList;

public class GrubbsTool
implements DetectTool {
    private double average;
    private double stdDeviation;
    private double[] G;
    private double G_MAX = 3.754;
    private ArrayList<Result> results;

    public GrubbsTool() {
    }

    public GrubbsTool(double g) {
        this.G_MAX = g;
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        this.results = new ArrayList();
        this.average = MathTool.getAverageFromArray(data);
        this.stdDeviation = MathTool.getStdDeviation(data);
        this.G = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.G[i] = (data[i] - this.average) / this.stdDeviation;
            if (!(this.G[i] > this.G_MAX)) continue;
            this.results.add(new Result(i, data[i]));
            System.out.println("Anomaly point! value is : " + data[i]);
        }
    }

    public ArrayList<Result> getResults() {
        return this.results;
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public void setStdDeviation(double stdDeviation) {
        this.stdDeviation = stdDeviation;
    }
}

