/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.ExponentialMoving;

import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Tool.FileTool;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class HoltWintersTool
implements DetectTool {
    private double alpha;
    private double step;
    private double lastAlpha;
    private int trainingTimes;
    private double[] s1;
    private double[] s2;
    private double[] ds1;
    private double[] ds2;
    private ArrayList<Result> results;
    private double THREADHOLD = 0.2;

    HoltWintersTool(double alpha, double step, int trainingTimes) {
        this.alpha = alpha;
        this.step = step;
        this.trainingTimes = trainingTimes;
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        this.results = new ArrayList();
        this.initial(data.length);
        this.trainModel(data);
        this.testModel(data);
    }

    private void trainModel(double[] data) {
        int count = 0;
        while (count < this.trainingTimes) {
            ++count;
            this.s1[0] = HoltWintersTool.getInitialValue(data, 5);
            this.s2[0] = this.s1[0];
            double sum = 0.0;
            for (int i = 1; i < data.length; ++i) {
                this.s1[i] = this.alpha * data[i - 1] + (1.0 - this.alpha) * this.s1[i - 1];
                this.s2[i] = this.alpha * this.s1[i] + (1.0 - this.alpha) * this.s2[i - 1];
                double A = 2.0 * this.s1[i] - this.s2[i];
                double B = this.alpha / (1.0 - this.alpha) * (this.s1[i] - this.s2[i]);
                double predict = this.s2[i];
                if (i == 1) {
                    this.ds1[i] = data[i - 1] - this.s1[i - 1];
                    this.ds2[i] = this.s1[i] + this.alpha * this.ds1[i] - this.s2[0];
                } else {
                    this.ds1[i] = data[i - 1] - this.ds1[i - 1];
                    this.ds2[i] = this.s1[i] + this.alpha * this.ds1[i] - this.s2[i - 1] + (1.0 - this.alpha) * this.ds2[i - 1];
                }
                sum += Math.pow(predict - data[i], 2.0);
                this.alpha -= this.step * ((predict - data[i]) * this.ds2[i]);
            }
            if (Math.abs(this.alpha - this.lastAlpha) < 1.0E-8) break;
            this.lastAlpha = this.alpha;
            System.out.println("MSE is " + sum / (double)data.length);
        }
    }

    private void initial(int length) {
        this.s1 = new double[length];
        this.s2 = new double[length];
        this.ds1 = new double[length];
        this.ds2 = new double[length];
    }

    private void testModel(double[] data) {
        this.s1[0] = HoltWintersTool.getInitialValue(data, 5);
        this.s2[0] = this.s1[0];
        double sum = 0.0;
        for (int i = 1; i < data.length; ++i) {
            this.s1[i] = this.alpha * data[i - 1] + (1.0 - this.alpha) * this.s1[i - 1];
            this.s2[i] = this.alpha * this.s1[i] + (1.0 - this.alpha) * this.s2[i - 1];
            double A = 2.0 * this.s1[i] - this.s2[i];
            double B = this.alpha / (1.0 - this.alpha) * (this.s1[i] - this.s2[i]);
            double predict = this.s2[i];
            if (!(Math.abs(predict - data[i]) > this.THREADHOLD)) continue;
            this.results.add(new Result(i, data[i]));
            System.out.println(data[i - 1] + "," + data[i] + "--------predict: " + predict);
        }
    }

    public void main(String[] args) throws FileNotFoundException {
        double[] data = FileTool.getData("data.json");
    }

    private static double getInitialValue(double[] data, int a) {
        if (data.length <= a) {
            System.out.println("Error: data length is not enough");
            return -1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < a; ++i) {
            sum += data[i];
        }
        return sum / (double)a;
    }

    public double[] getS1() {
        return this.s1;
    }

    public void setS1(double[] s1) {
        this.s1 = s1;
    }

    public double[] getS2() {
        return this.s2;
    }

    public void setS2(double[] s2) {
        this.s2 = s2;
    }

    public double[] getDs1() {
        return this.ds1;
    }

    public void setDs1(double[] ds1) {
        this.ds1 = ds1;
    }

    public double[] getDs2() {
        return this.ds2;
    }

    public void setDs2(double[] ds2) {
        this.ds2 = ds2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public ArrayList<Result> getResults() {
        return this.results;
    }

    public void setResults(ArrayList<Result> results) {
        this.results = results;
    }

    public double getTHREADHOLD() {
        return this.THREADHOLD;
    }

    public void setTHREADHOLD(double THREADHOLD) {
        this.THREADHOLD = THREADHOLD;
    }
}

