/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.IsolationTree;

import com.anomalydetect.IsolationTree.IsolationTree;
import com.anomalydetect.Tool.MathTool;
import java.util.ArrayList;
import java.util.Random;

public class IsolationForest {
    private ArrayList<IsolationTree> forest;
    private int maxTreeNum;
    private int maxTreeHeight;
    private int subSamplingNum;
    private int dataLengeth;

    public IsolationForest(int maxTreeNum, int maxSampling) {
        this.subSamplingNum = maxSampling;
        this.maxTreeNum = maxTreeNum;
        this.maxTreeHeight = (int)Math.ceil(MathTool.log2(maxSampling));
        this.forest = new ArrayList(maxTreeNum);
    }

    public void createForest(double[] data) {
        this.dataLengeth = data.length;
        boolean isSample = false;
        if (data.length > this.subSamplingNum) {
            isSample = true;
        }
        for (int i = 0; i < this.maxTreeNum; ++i) {
            IsolationTree iTree = new IsolationTree();
            if (isSample) {
                data = this.subSampling(data);
            }
            iTree.create(data, this.maxTreeHeight);
            this.forest.add(iTree);
        }
    }

    public double searchForest(double d) {
        double hx = 0.0;
        for (IsolationTree tree : this.forest) {
            hx += tree.pathLength(d);
        }
        double cn = 2.0 * (Math.log((double)this.dataLengeth - 1.0) + MathTool.EulerConstant) - (double)(2 * (this.dataLengeth - 1) / this.dataLengeth);
        return Math.pow(2.0, -hx / (double)this.maxTreeNum / cn);
    }

    private double[] subSampling(double[] data) {
        int n = data.length;
        double[] sample = new double[this.subSamplingNum];
        for (int i = 0; i < this.subSamplingNum; ++i) {
            int r = new Random().nextInt(n);
            sample[i] = data[r];
            data[r] = data[--n];
        }
        return sample;
    }
}

