/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.IsolationTree;

import com.anomalydetect.IsolationTree.IsolationTreeNode;
import com.anomalydetect.Tool.MathTool;
import java.util.Arrays;

public class IsolationTree {
    private IsolationTreeNode root;

    public void create(double[] data, int maxHeight) {
        Arrays.sort(data);
        this.root = this.createByR(data, 0, maxHeight, 0, data.length - 1);
    }

    private IsolationTreeNode createByR(double[] data, int currentHeight, int maxHeight, int start, int end) {
        int i;
        double divd;
        if (start > end) {
            return null;
        }
        if (currentHeight == maxHeight || end == start) {
            IsolationTreeNode node = new IsolationTreeNode(0.0);
            node.size = end - start + 1;
            return node;
        }
        double min = data[start];
        double max = data[end];
        while ((divd = min + Math.random() * max) <= min || divd >= max) {
        }
        for (i = start; i <= end && !(data[i] >= divd); ++i) {
        }
        IsolationTreeNode node = new IsolationTreeNode(divd);
        node.left = this.createByR(data, currentHeight + 1, maxHeight, start, i - 1);
        node.right = this.createByR(data, currentHeight + 1, maxHeight, i, end);
        return node;
    }

    public double pathLength(double x) {
        return this.pathLengthM(x, this.root, 1);
    }

    private double pathLengthM(double x, IsolationTreeNode node, int currHeight) {
        if (node.isExtenal()) {
            return (double)currHeight + this.e(node.size);
        }
        if (x >= node.divdNum) {
            return this.pathLengthM(x, node.right, currHeight + 1);
        }
        return this.pathLengthM(x, node.left, currHeight + 1);
    }

    private double e(int n) {
        double s = n;
        return 2.0 * (Math.log(s) + MathTool.EulerConstant) + 2.0 * (s - 1.0) / s;
    }
}

