/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.IsolationTree;

import com.anomalydetect.IsolationTree.IsolationForest;
import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import java.util.ArrayList;
import java.util.List;

public class IsolationTreeTool
implements DetectTool {
    private int maxTreeNum = 100;
    private int maxSampling = 256;
    private double factor = 0.6f;
    private ArrayList<Result> results;
    private IsolationForest forest;

    public IsolationTreeTool() {
    }

    public IsolationTreeTool(int maxTreeNum, int maxSampling) {
        this.maxTreeNum = maxTreeNum;
        this.maxSampling = maxSampling;
    }

    @Override
    public void timeSeriesAnalyse(double[] data) {
        this.results = new ArrayList();
        IsolationForest tempForest = new IsolationForest(this.maxTreeNum, this.maxSampling);
        tempForest.createForest((double[])data.clone());
        this.forest = tempForest;
        this.cutAnomaly(data, this.factor);
    }

    public void cutAnomaly(double[] data, double factor) {
        for (int i = 0; i < data.length; ++i) {
            if (!(this.forest.searchForest(data[i]) > factor)) continue;
            this.results.add(new Result(i, data[i]));
        }
    }

    @Override
    public List<Result> getResults() {
        return this.results;
    }

    public int getMaxSampling() {
        return this.maxSampling;
    }

    public void setMaxSampling(int maxSampling) {
        this.maxSampling = maxSampling;
    }

    public int getMaxTreeNum() {
        return this.maxTreeNum;
    }

    public void setMaxTreeNum(int maxTreeNum) {
        this.maxTreeNum = maxTreeNum;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }
}

